"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = __importDefault(require("lodash"));
const OS_1 = require("../OS");
const receiver_1 = require("../receiver/receiver");
const conversations_1 = require("../bchat/conversations");
const utils_1 = require("../bchat/utils");
const User_1 = require("../bchat/utils/User");
const util_1 = require("../util");
const expiringMessages_1 = require("../util/expiringMessages");
const notifications_1 = require("../util/notifications");
const registration_1 = require("../util/registration");
const storage_1 = require("../util/storage");
const Data = __importStar(require("../data/data"));
const backbone_1 = __importDefault(require("backbone"));
const BchatRegistrationView_1 = require("../components/registration/BchatRegistrationView");
const BchatInboxView_1 = require("../components/BchatInboxView");
const logs_1 = require("../node/logs");
const react_dom_1 = __importDefault(require("react-dom"));
const react_1 = __importDefault(require("react"));
const cross_port_killer_1 = __importDefault(require("cross-port-killer"));
const errors_1 = require("../bchat/utils/errors");
const data_1 = __importDefault(require("@emoji-mart/data"));
const emoji_1 = require("../util/emoji");
const i18n_1 = require("../util/i18n");
const opengroups_1 = require("../data/opengroups");
document.body.addEventListener('dragover', e => {
    e.preventDefault();
    e.stopPropagation();
}, false);
document.body.addEventListener('drop', e => {
    e.preventDefault();
    e.stopPropagation();
}, false);
const images = [];
function preload(list) {
    for (let index = 0, max = list.length; index < max; index += 1) {
        const image = new Image();
        image.src = `./images/${list[index]}`;
        images.push(image);
    }
}
preload([
    'alert-outline.svg',
    'check.svg',
    'error.svg',
    'file-gradient.svg',
    'file.svg',
    'image.svg',
    'microphone.svg',
    'movie.svg',
    'open_link.svg',
    'play.svg',
    'save.svg',
    'shield.svg',
    'timer.svg',
    'video.svg',
    'warning.svg',
    'x.svg',
]);
window.setImmediate = window.nodeSetImmediate;
window.globalOnlineStatus = true;
window.getGlobalOnlineStatus = () => window.globalOnlineStatus;
window.log.info('background page reloaded');
window.log.info('environment:', window.getEnvironment());
let newVersion = false;
window.document.title = window.getTitle();
const WhisperEvents = lodash_1.default.clone(backbone_1.default.Events);
window.Whisper = window.Whisper || {};
window.Whisper.events = WhisperEvents;
window.log.info('Storage fetch');
void storage_1.Storage.fetch();
function mapOldThemeToNew(theme) {
    switch (theme) {
        case 'dark':
        case 'light':
            return theme;
        case 'android-dark':
            return 'dark';
        case 'android':
        case 'ios':
        default:
            return 'light';
    }
}
let first = true;
storage_1.Storage.onready(async () => {
    if (!first) {
        return;
    }
    first = false;
    window.updateZoomFactor();
    if (registration_1.Registration.isDone() && !storage_1.Storage.get('primaryDevicePubKey')) {
        await storage_1.Storage.put('primaryDevicePubKey', (0, User_1.getOurPubKeyStrFromCache)());
    }
    window.Events = {
        getThemeSetting: () => storage_1.Storage.get('theme-setting', 'dark'),
        setThemeSetting: async (value) => {
            await storage_1.Storage.put('theme-setting', value);
        },
        getHideMenuBar: () => storage_1.Storage.get('hide-menu-bar'),
        setHideMenuBar: async (value) => {
            await storage_1.Storage.put('hide-menu-bar', value);
            window.setAutoHideMenuBar(false);
            window.setMenuBarVisibility(!value);
        },
        getSpellCheck: () => storage_1.Storage.get('spell-check', true),
        setSpellCheck: async (value) => {
            await storage_1.Storage.put('spell-check', value);
        },
        shutdown: async () => {
            utils_1.AttachmentDownloads.stop();
            await Data.shutdown();
        },
    };
    const currentVersion = window.getVersion();
    const lastVersion = storage_1.Storage.get('version');
    newVersion = !lastVersion || currentVersion !== lastVersion;
    await storage_1.Storage.put('version', currentVersion);
    if (newVersion) {
        window.log.info(`New version detected: ${currentVersion}; previous: ${lastVersion}`);
        await Data.cleanupOrphanedAttachments();
        await (0, logs_1.deleteAllLogs)();
    }
    const themeSetting = window.Events.getThemeSetting();
    const newThemeSetting = mapOldThemeToNew(themeSetting);
    window.Events.setThemeSetting(newThemeSetting);
    try {
        (0, emoji_1.initialiseEmojiData)(data_1.default);
        await utils_1.AttachmentDownloads.initAttachmentPaths();
        await Promise.all([
            (0, conversations_1.getConversationController)().load(),
            util_1.BlockedNumberController.load(),
            opengroups_1.OpenGroupData.opengroupRoomsLoad(),
            (0, i18n_1.loadEmojiPanelI18n)(),
        ]);
    }
    catch (error) {
        window.log.error('main_start.js: ConversationController failed to load:', error && error.stack ? error.stack : error);
    }
    finally {
        void start();
    }
});
async function manageExpiringData() {
    await Data.cleanSeenMessages();
    await Data.cleanLastHashes();
    setTimeout(manageExpiringData, 1000 * 60 * 60);
}
async function start() {
    void manageExpiringData();
    window.dispatchEvent(new Event('storage_ready'));
    window.log.info('Cleanup: starting...');
    const results = await Promise.all([Data.getOutgoingWithoutExpiresAt()]);
    const messagesForCleanup = results.reduce((array, current) => array.concat(current.toArray()), []);
    window.log.info(`Cleanup: Found ${messagesForCleanup.length} messages for cleanup`);
    await Promise.all(messagesForCleanup.map(async (message) => {
        const sentAt = message.get('sent_at');
        if (message.hasErrors()) {
            return;
        }
        window.log.info(`Cleanup: Deleting unsent message ${sentAt}`);
        await Data.removeMessage(message.id);
    }));
    window.log.info('Cleanup: complete');
    window.log.info('listening for registration events');
    WhisperEvents.on('registration_done', async () => {
        window.log.info('handling registration event');
        storage_1.Storage.onready(async () => {
            await storage_1.Storage.put('link-preview-setting', false);
        });
        await connect();
    });
    function openInbox() {
        const rtlLocales = ['fa', 'ar', 'he'];
        const loc = window.i18n.getLocale();
        if (rtlLocales.includes(loc) && !document.getElementById('body')?.classList.contains('rtl')) {
            document.getElementById('body')?.classList.add('rtl');
        }
        const hideMenuBar = storage_1.Storage.get('hide-menu-bar', true);
        window.setAutoHideMenuBar(hideMenuBar);
        window.setMenuBarVisibility(!hideMenuBar);
        (0, conversations_1.getConversationController)()
            .loadPromise()
            ?.then(() => {
            react_dom_1.default.render(react_1.default.createElement(BchatInboxView_1.BchatInboxView, null), document.getElementById('root'));
        });
    }
    function openStandAlone() {
        react_dom_1.default.render(react_1.default.createElement(BchatRegistrationView_1.BchatRegistrationView, null), document.getElementById('root'));
    }
    expiringMessages_1.ExpirationTimerOptions.initExpiringMessageListener();
    if (registration_1.Registration.isDone() && !(0, storage_1.isSignInByLinking)()) {
        await connect();
        openInbox();
    }
    else {
        openStandAlone();
    }
    window.addEventListener('focus', () => {
        notifications_1.Notifications.clear();
    });
    window.addEventListener('unload', () => {
        notifications_1.Notifications.fastClear();
    });
    const prevLaunchCount = window.getSettingValue('launch-count');
    const launchCount = !prevLaunchCount ? 1 : prevLaunchCount + 1;
    window.setSettingValue('launch-count', launchCount);
    if (launchCount === 1) {
        window.setSettingValue('hide-menu-bar', true);
        window.setSettingValue('link-preview-setting', false);
    }
    window.setTheme = newTheme => {
        window.Events.setThemeSetting(newTheme);
    };
    window.toggleMenuBar = () => {
        const current = window.getSettingValue('hide-menu-bar');
        if (current === undefined) {
            window.Events.setHideMenuBar(false);
            return;
        }
        window.Events.setHideMenuBar(!current);
    };
    window.toggleSpellCheck = () => {
        const currentValue = window.getSettingValue('spell-check');
        const newValue = currentValue !== undefined ? !currentValue : false;
        window.Events.setSpellCheck(newValue);
        utils_1.ToastUtils.pushRestartNeeded();
    };
    window.toggleMediaPermissions = async () => {
        const value = window.getMediaPermissions();
        if (value === true) {
            const valueCallPermissions = window.getCallMediaPermissions();
            if (valueCallPermissions) {
                window.log.info('toggleMediaPermissions : forcing callPermissions to false');
                await window.toggleCallMediaPermissionsTo(false);
            }
        }
        if (value === false && (0, OS_1.isMacOS)()) {
            window.askForMediaAccess();
        }
        window.setMediaPermissions(!value);
    };
    window.toggleCallMediaPermissionsTo = async (enabled) => {
        const previousValue = window.getCallMediaPermissions();
        if (previousValue === enabled) {
            return;
        }
        if (previousValue === false) {
            if ((0, OS_1.isMacOS)()) {
                window.askForMediaAccess();
            }
            window.log.info('toggleCallMediaPermissionsTo : forcing audio/video to true');
            window.setMediaPermissions(true);
        }
        window.setCallMediaPermissions(enabled);
    };
    window.openFromNotification = async (conversationKey) => {
        window.showWindow();
        if (conversationKey) {
            await window.openConversationWithMessages({ conversationKey, messageId: null });
        }
        else {
            openInbox();
        }
    };
    WhisperEvents.on('openInbox', () => {
        openInbox();
    });
}
let disconnectTimer = null;
function onOffline() {
    window.log.info('offline');
    window.globalOnlineStatus = false;
    window.removeEventListener('offline', onOffline);
    window.addEventListener('online', onOnline);
    disconnectTimer = global.setTimeout(disconnect, 1000);
}
function onOnline() {
    window.log.info('online');
    window.globalOnlineStatus = true;
    window.removeEventListener('online', onOnline);
    window.addEventListener('offline', onOffline);
    if (disconnectTimer) {
        window.log.warn('Already online. Had a blip in online/offline status.');
        clearTimeout(disconnectTimer);
        disconnectTimer = null;
        return;
    }
    if (disconnectTimer) {
        clearTimeout(disconnectTimer);
        disconnectTimer = null;
    }
    void connect();
}
function disconnect() {
    window.log.info('disconnect');
    disconnectTimer = null;
    utils_1.AttachmentDownloads.stop();
}
let connectCount = 0;
async function connect() {
    window.log.info('connect');
    (0, cross_port_killer_1.default)(64371)
        .then()
        .catch(err => {
        throw new errors_1.HTTPError('beldex_rpc_port', err);
    });
    if (connectCount === 0 && navigator.onLine) {
        window.addEventListener('offline', onOffline);
    }
    if (connectCount === 0 && !navigator.onLine) {
        window.log.warn('Starting up offline; will connect when we have network access');
        window.addEventListener('online', onOnline);
        onEmpty();
        return;
    }
    if (!registration_1.Registration.everDone()) {
        return;
    }
    connectCount += 1;
    notifications_1.Notifications.disable();
    setTimeout(() => {
        notifications_1.Notifications.enable();
    }, 10 * 1000);
    await (0, receiver_1.queueAllCached)();
    await utils_1.AttachmentDownloads.start({
        logger: window.log,
    });
    window.isOnline = true;
}
function onEmpty() {
    window.readyForUpdates();
    notifications_1.Notifications.enable();
}
class TextScramble {
    frame;
    queue;
    el;
    chars;
    resolve;
    frameRequest;
    constructor(el) {
        this.el = el;
        this.chars = '0123456789abcdef';
        this.update = this.update.bind(this);
    }
    async setText(newText) {
        const oldText = this.el.value;
        const length = Math.max(oldText.length, newText.length);
        const promise = new Promise(resolve => (this.resolve = resolve));
        this.queue = [];
        for (let i = 0; i < length; i++) {
            const from = oldText[i] || '';
            const to = newText[i] || '';
            const startNumber = Math.floor(Math.random() * 40);
            const end = startNumber + Math.floor(Math.random() * 40);
            this.queue.push({
                from,
                to,
                start: startNumber,
                end,
            });
        }
        cancelAnimationFrame(this.frameRequest);
        this.frame = 0;
        this.update();
        return promise;
    }
    update() {
        let output = '';
        let complete = 0;
        for (let i = 0, n = this.queue.length; i < n; i++) {
            const { from, to, start: startNumber, end } = this.queue[i];
            let { char } = this.queue[i];
            if (this.frame >= end) {
                complete++;
                output += to;
            }
            else if (this.frame >= startNumber) {
                if (!char || Math.random() < 0.28) {
                    char = this.randomChar();
                    this.queue[i].char = char;
                }
                output += char;
            }
            else {
                output += from;
            }
        }
        this.el.value = output;
        if (complete === this.queue.length) {
            this.resolve();
        }
        else {
            this.frameRequest = requestAnimationFrame(this.update);
            this.frame++;
        }
    }
    randomChar() {
        return this.chars[Math.floor(Math.random() * this.chars.length)];
    }
}
window.bchat = window.bchat || {};
window.bchat.setNewBchatID = (BchatID) => {
    const el = document.querySelector('.bchat-id-editable-textarea');
    const fx = new TextScramble(el);
    if (el) {
        el.value = BchatID;
    }
    void fx.setText(BchatID);
};
