"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPublicMessageSentFromNotUs = exports.createPublicMessageSentFromUs = exports.createSwarmMessageSentFromNotUs = exports.createSwarmMessageSentFromUs = void 0;
const utils_1 = require("../bchat/utils");
const message_1 = require("./message");
function getSharedAttributesForSwarmMessage({ conversationId, messageHash, sentAt, }) {
    const now = Date.now();
    return {
        sent_at: sentAt,
        received_at: now,
        conversationId,
        messageHash,
    };
}
function createSwarmMessageSentFromUs(args) {
    const messageData = {
        ...getSharedAttributesForSwarmMessage(args),
        ...getSharedAttributesForOutgoingMessage(),
        expirationStartTimestamp: Math.min(args.sentAt, Date.now()),
    };
    return new message_1.MessageModel(messageData);
}
exports.createSwarmMessageSentFromUs = createSwarmMessageSentFromUs;
function createSwarmMessageSentFromNotUs(args) {
    const messageData = {
        ...getSharedAttributesForSwarmMessage(args),
        ...getSharedAttributesForIncomingMessage(),
        source: args.sender,
    };
    return new message_1.MessageModel(messageData);
}
exports.createSwarmMessageSentFromNotUs = createSwarmMessageSentFromNotUs;
function getSharedAttributesForPublicMessage({ serverTimestamp, serverId, conversationId, }) {
    return {
        serverTimestamp: serverTimestamp || undefined,
        serverId: serverId || undefined,
        sent_at: serverTimestamp,
        received_at: serverTimestamp,
        isPublic: true,
        conversationId,
        messageHash: '',
        expirationStartTimestamp: undefined,
    };
}
function getSharedAttributesForOutgoingMessage() {
    return {
        source: utils_1.UserUtils.getOurPubKeyStrFromCache(),
        unread: 0,
        sent_to: [],
        sent: true,
        type: 'outgoing',
        direction: 'outgoing',
    };
}
function getSharedAttributesForIncomingMessage() {
    return {
        unread: 1,
        type: 'incoming',
        direction: 'incoming',
    };
}
function createPublicMessageSentFromUs(args) {
    const messageData = {
        ...getSharedAttributesForPublicMessage(args),
        ...getSharedAttributesForOutgoingMessage(),
    };
    return new message_1.MessageModel(messageData);
}
exports.createPublicMessageSentFromUs = createPublicMessageSentFromUs;
function createPublicMessageSentFromNotUs(args) {
    const messageData = {
        ...getSharedAttributesForPublicMessage(args),
        ...getSharedAttributesForIncomingMessage(),
        source: args.sender,
    };
    return new message_1.MessageModel(messageData);
}
exports.createPublicMessageSentFromNotUs = createPublicMessageSentFromNotUs;
