"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fillMessageAttributesWithDefaults = exports.MessageDirection = void 0;
const lodash_1 = require("lodash");
const uuid_1 = require("uuid");
var MessageDirection;
(function (MessageDirection) {
    MessageDirection["outgoing"] = "outgoing";
    MessageDirection["incoming"] = "incoming";
    MessageDirection["any"] = "%";
})(MessageDirection = exports.MessageDirection || (exports.MessageDirection = {}));
const fillMessageAttributesWithDefaults = (optAttributes) => {
    const defaulted = (0, lodash_1.defaultsDeep)(optAttributes, {
        expireTimer: 0,
        id: (0, uuid_1.v4)(),
        unread: 0,
    });
    if (defaulted.delivered) {
        delete defaulted.delivered;
    }
    if (defaulted.delivered_to) {
        delete defaulted.delivered_to;
    }
    return defaulted;
};
exports.fillMessageAttributesWithDefaults = fillMessageAttributesWithDefaults;
