"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.userConfig = void 0;
const path_1 = __importDefault(require("path"));
const process_1 = __importDefault(require("process"));
const electron_1 = require("electron");
const base_config_1 = require("./base_config");
let storageProfile;
const { NODE_ENV: environment, NODE_APP_INSTANCE: instance } = process_1.default.env;
const isValidInstance = typeof instance === 'string' && instance.length > 0;
const isProduction = environment === 'production' && !isValidInstance;
if (!isProduction) {
    storageProfile = environment;
    if (isValidInstance) {
        storageProfile = (storageProfile || '').concat(`-${instance}`);
    }
}
if (storageProfile) {
    const userData = path_1.default.join(electron_1.app.getPath('appData'), `bchat-${storageProfile}`);
    electron_1.app.setPath('userData', userData);
}
console.log(`userData: ${electron_1.app.getPath('userData')}`);
const userDataPath = electron_1.app.getPath('userData');
const targetPath = path_1.default.join(userDataPath, 'config.json');
exports.userConfig = (0, base_config_1.start)('user', targetPath);
