"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.load = void 0;
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const lodash_1 = __importDefault(require("lodash"));
const getRootPath_1 = require("./getRootPath");
function normalizeLocaleName(locale) {
    if (/^en-/.test(locale)) {
        return 'en';
    }
    return locale;
}
function getLocaleMessages(locale) {
    console.log(locale);
    const targetFile = path_1.default.join((0, getRootPath_1.getAppRootPath)(), '_locales', 'en', 'messages.json');
    return JSON.parse(fs_1.default.readFileSync(targetFile, 'utf-8'));
}
function load({ appLocale, logger, } = {}) {
    if (!appLocale) {
        throw new TypeError('`appLocale` is required');
    }
    if (!logger || !logger.error) {
        throw new TypeError('`logger.error` is required');
    }
    const english = getLocaleMessages('en');
    let localeName = normalizeLocaleName(appLocale);
    let messages;
    try {
        messages = getLocaleMessages(localeName);
        messages = lodash_1.default.merge(english, messages);
    }
    catch (e) {
        logger.error(`Problem loading messages for locale ${localeName} ${e.stack}`);
        logger.error('Falling back to en locale');
        localeName = 'en';
        messages = english;
    }
    return {
        name: localeName,
        messages,
    };
}
exports.load = load;
