"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteAllLogs = void 0;
const electron_1 = require("electron");
async function deleteAllLogs() {
    return new Promise((resolve, reject) => {
        electron_1.ipcRenderer.once('delete-all-logs-complete', resolve);
        setTimeout(() => {
            reject(new Error('Request to delete all logs timed out'));
        }, 5000);
        electron_1.ipcRenderer.send('delete-all-logs');
    });
}
exports.deleteAllLogs = deleteAllLogs;
