"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeSqlChannel = void 0;
const electron_1 = require("electron");
const sql_1 = require("./sql");
const user_config_1 = require("./config/user_config");
const ephemeral_config_1 = require("./config/ephemeral_config");
let initialized = false;
const SQL_CHANNEL_KEY = 'sql-channel';
const ERASE_SQL_KEY = 'erase-sql-key';
function initializeSqlChannel() {
    if (initialized) {
        throw new Error('sqlChannels: already initialized!');
    }
    electron_1.ipcMain.on(SQL_CHANNEL_KEY, (event, jobId, callName, ...args) => {
        try {
            const fn = sql_1.sqlNode[callName];
            if (!fn) {
                throw new Error(`sql channel: ${callName} is not an available function`);
            }
            const result = fn(...args);
            event.sender.send(`${SQL_CHANNEL_KEY}-done`, jobId, null, result);
        }
        catch (error) {
            const errorForDisplay = error && error.stack ? error.stack : error;
            console.log(`sql channel error with call ${callName}: ${errorForDisplay}`);
        }
    });
    electron_1.ipcMain.on(ERASE_SQL_KEY, event => {
        try {
            user_config_1.userConfig.remove();
            ephemeral_config_1.ephemeralConfig.remove();
            event.sender.send(`${ERASE_SQL_KEY}-done`);
        }
        catch (error) {
            const errorForDisplay = error && error.stack ? error.stack : error;
            console.log(`sql-erase error: ${errorForDisplay}`);
            event.sender.send(`${ERASE_SQL_KEY}-done`, error);
        }
    });
    electron_1.ipcMain.handle('get-user-data-path', () => {
        return electron_1.app.getPath('userData');
    });
    electron_1.ipcMain.handle('get-data-path', () => {
        return electron_1.app.getAppPath();
    });
    initialized = true;
}
exports.initializeSqlChannel = initializeSqlChannel;
