"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createStore = exports.persistConfig = void 0;
const redux_logger_1 = require("redux-logger");
const toolkit_1 = require("@reduxjs/toolkit");
const reducer_1 = require("./reducer");
const redux_persist_1 = require("redux-persist");
const redux_promise_middleware_1 = __importDefault(require("redux-promise-middleware"));
const storage_1 = __importDefault(require("redux-persist/lib/storage"));
const env = window.getEnvironment();
const directConsole = {
    log: console._log,
    groupCollapsed: console.groupCollapsed,
    group: console.group,
    groupEnd: console.groupEnd,
    warn: console.warn,
    error: console.error,
};
const logger = (0, redux_logger_1.createLogger)({
    logger: directConsole,
});
exports.persistConfig = {
    key: 'root',
    storage: storage_1.default,
    whitelist: ['userConfig'],
};
const persistedReducer = (0, redux_persist_1.persistReducer)(exports.persistConfig, reducer_1.rootReducer);
const disableLogging = true;
const middlewareList = disableLogging ? [redux_promise_middleware_1.default] : [logger, redux_promise_middleware_1.default];
const createStore = (initialState) => (0, toolkit_1.configureStore)({
    reducer: persistedReducer,
    preloadedState: initialState,
    middleware: (getDefaultMiddleware) => getDefaultMiddleware({
        serializableCheck: true,
        immutableCheck: true,
    }).concat(middlewareList),
});
exports.createStore = createStore;
