"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.callReducer = exports.setFullScreenCall = exports.startingCallWith = exports.callReconnecting = exports.callConnected = exports.answerCall = exports.endCall = exports.incomingCall = exports.initialCallState = void 0;
const toolkit_1 = require("@reduxjs/toolkit");
const RingingManager_1 = require("../../bchat/utils/RingingManager");
exports.initialCallState = {
    ongoingWith: undefined,
    ongoingCallStatus: undefined,
    callIsInFullScreen: false,
};
const callSlice = (0, toolkit_1.createSlice)({
    name: 'call',
    initialState: exports.initialCallState,
    reducers: {
        incomingCall(state, action) {
            const callerPubkey = action.payload.pubkey;
            if (state.ongoingWith && state.ongoingWith !== callerPubkey) {
                window.log.warn(`Got an incoming call action for ${callerPubkey} but we are already in a call.`);
                return state;
            }
            state.ongoingWith = callerPubkey;
            state.ongoingCallStatus = 'incoming';
            (0, RingingManager_1.setIsRinging)(true);
            return state;
        },
        endCall(state) {
            state.ongoingCallStatus = undefined;
            state.ongoingWith = undefined;
            (0, RingingManager_1.setIsRinging)(false);
            return state;
        },
        answerCall(state, action) {
            const callerPubkey = action.payload.pubkey;
            if (state.ongoingWith !== callerPubkey || state.ongoingCallStatus !== 'incoming') {
                window.log.info('cannot answer a call we are not displaying a dialog with');
                return state;
            }
            state.ongoingCallStatus = 'connecting';
            state.callIsInFullScreen = false;
            (0, RingingManager_1.setIsRinging)(false);
            return state;
        },
        callConnected(state, action) {
            const callerPubkey = action.payload.pubkey;
            if (callerPubkey !== state.ongoingWith) {
                window.log.info('cannot answer a call we did not start or receive first');
                return state;
            }
            const existingCallState = state.ongoingCallStatus;
            if (existingCallState !== 'connecting' && existingCallState !== 'offering') {
                window.log.info('cannot answer a call we are not connecting (and so answered) to or offering a call');
                return state;
            }
            (0, RingingManager_1.setIsRinging)(false);
            state.ongoingCallStatus = 'ongoing';
            state.callIsInFullScreen = false;
            return state;
        },
        callReconnecting(state, action) {
            const callerPubkey = action.payload.pubkey;
            if (callerPubkey !== state.ongoingWith) {
                window.log.info('cannot reconnect a call we did not start or receive first');
                return state;
            }
            const existingCallState = state.ongoingCallStatus;
            if (existingCallState !== 'ongoing') {
                window.log.info('cannot reconnect a call we are not ongoing');
                return state;
            }
            state.ongoingCallStatus = 'connecting';
            return state;
        },
        startingCallWith(state, action) {
            if (state.ongoingWith) {
                window.log.warn('cannot start a call with an ongoing call already: ongoingWith');
                return state;
            }
            if (state.ongoingCallStatus) {
                window.log.warn('cannot start a call with an ongoing call already: ongoingCallStatus');
                return state;
            }
            (0, RingingManager_1.setIsRinging)(true);
            const callerPubkey = action.payload.pubkey;
            state.ongoingWith = callerPubkey;
            state.ongoingCallStatus = 'offering';
            state.callIsInFullScreen = false;
            return state;
        },
        setFullScreenCall(state, action) {
            if (state.ongoingWith && state.ongoingCallStatus === 'ongoing' && action.payload) {
                state.callIsInFullScreen = true;
                return state;
            }
            state.callIsInFullScreen = false;
            return state;
        },
    },
});
const { actions, reducer } = callSlice;
exports.incomingCall = actions.incomingCall, exports.endCall = actions.endCall, exports.answerCall = actions.answerCall, exports.callConnected = actions.callConnected, exports.callReconnecting = actions.callReconnecting, exports.startingCallWith = actions.startingCallWith, exports.setFullScreenCall = actions.setFullScreenCall;
exports.callReducer = reducer;
