"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.openCallHistory = exports.callHistoryReducer = exports.updateCallhistory = exports.reducer = exports.actions = exports.initialCallHistoryState = void 0;
const toolkit_1 = require("@reduxjs/toolkit");
const moment_1 = __importDefault(require("moment"));
const data_1 = require("../../data/data");
const conversations_1 = require("../selectors/conversations");
exports.initialCallHistoryState = {
    callHistoryList: [],
};
const callHistorySlice = (0, toolkit_1.createSlice)({
    name: 'callHistory',
    initialState: exports.initialCallHistoryState,
    reducers: {
        updateCallhistory: (state, action) => {
            return { ...state, callHistoryList: action.payload };
        },
    },
});
exports.actions = callHistorySlice.actions, exports.reducer = callHistorySlice.reducer;
exports.updateCallhistory = exports.actions.updateCallhistory;
exports.callHistoryReducer = exports.reducer;
async function openCallHistory() {
    const state = window.inboxStore?.getState();
    const members = (0, conversations_1.getDirectContacts)(state);
    const callHistory = (await Promise.all(members.map((item) => (0, data_1.getCallMessagesByConversation)(item.id)))).flat();
    const sortedCallHistory = callHistory.sort((a, b) => b.received_at - a.received_at);
    let verify_data = null;
    const refinedHistory = [];
    for (const item of sortedCallHistory) {
        const verifyCalls = verify_data &&
            item.conversationId === verify_data.conversationId &&
            item.callNotificationType === verify_data.callNotificationType &&
            (0, moment_1.default)(item.received_at).isSame((0, moment_1.default)(verify_data.received_at), 'day');
        if (verifyCalls) {
            verify_data.call_details.push({
                callType: item.callNotificationType,
                timeStamp: item.received_at,
                messageId: item.id,
            });
        }
        else {
            const newEntry = {
                callNotificationType: item.callNotificationType,
                conversationId: item.conversationId,
                direction: item.direction,
                received_at: item.received_at,
                call_details: [
                    {
                        callType: item.callNotificationType,
                        timeStamp: item.received_at,
                        messageId: item.id,
                    },
                ],
            };
            refinedHistory.push(newEntry);
            verify_data = newEntry;
        }
    }
    window.inboxStore?.dispatch((0, exports.updateCallhistory)(refinedHistory));
}
exports.openCallHistory = openCallHistory;
