"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultRoomReducer = exports.updateDefaultRoomsInProgress = exports.updateDefaultBase64RoomData = exports.updateDefaultRooms = exports.initialDefaultRoomState = void 0;
const toolkit_1 = require("@reduxjs/toolkit");
exports.initialDefaultRoomState = {
    rooms: [],
    inProgress: false,
};
const defaultRoomsSlice = (0, toolkit_1.createSlice)({
    name: 'defaultRooms',
    initialState: exports.initialDefaultRoomState,
    reducers: {
        updateDefaultRooms(state, action) {
            window?.log?.info('updating default rooms', action.payload);
            const rooms = action.payload;
            return { ...state, rooms: rooms };
        },
        updateDefaultRoomsInProgress(state, action) {
            const inProgress = action.payload;
            return { ...state, inProgress };
        },
        updateDefaultBase64RoomData(state, action) {
            const payload = action.payload;
            const newRoomsState = state.rooms.map(room => {
                if (room.id === payload.roomId) {
                    return {
                        ...room,
                        base64Data: payload.base64Data,
                    };
                }
                return room;
            });
            return { ...state, rooms: newRoomsState };
        },
    },
});
const { actions, reducer } = defaultRoomsSlice;
exports.updateDefaultRooms = actions.updateDefaultRooms, exports.updateDefaultBase64RoomData = actions.updateDefaultBase64RoomData, exports.updateDefaultRoomsInProgress = actions.updateDefaultRoomsInProgress;
exports.defaultRoomReducer = reducer;
