"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultOnionReducer = exports.updateIsOnline = exports.updateOnionPaths = exports.initialOnionPathState = void 0;
const toolkit_1 = require("@reduxjs/toolkit");
exports.initialOnionPathState = {
    snodePaths: new Array(),
    isOnline: false,
};
const onionSlice = (0, toolkit_1.createSlice)({
    name: 'onionPaths',
    initialState: exports.initialOnionPathState,
    reducers: {
        updateOnionPaths(state, action) {
            state.snodePaths = action.payload;
            return state;
        },
        updateIsOnline(state, action) {
            state.isOnline = action.payload;
            return state;
        },
    },
});
const { actions, reducer } = onionSlice;
exports.updateOnionPaths = actions.updateOnionPaths, exports.updateIsOnline = actions.updateIsOnline;
exports.defaultOnionReducer = reducer;
