"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeStagedAttachmentInConversation = exports.removeAllStagedAttachmentsInConversation = exports.addStagedAttachmentsInConversation = exports.reducer = exports.actions = exports.getEmptyStagedAttachmentsState = void 0;
const toolkit_1 = require("@reduxjs/toolkit");
const lodash_1 = __importDefault(require("lodash"));
function getEmptyStagedAttachmentsState() {
    return {
        stagedAttachments: {},
    };
}
exports.getEmptyStagedAttachmentsState = getEmptyStagedAttachmentsState;
const stagedAttachmentsSlice = (0, toolkit_1.createSlice)({
    name: 'stagedAttachments',
    initialState: getEmptyStagedAttachmentsState(),
    reducers: {
        addStagedAttachmentsInConversation(state, action) {
            const { conversationKey, newAttachments } = action.payload;
            if (newAttachments.length === 0) {
                return state;
            }
            const currentStagedAttachments = state.stagedAttachments[conversationKey] || [];
            if (newAttachments.some(a => a.isVoiceMessage) && currentStagedAttachments.length > 0) {
                window?.log?.warn('A voice note cannot be sent with other attachments');
                return state;
            }
            const allAttachments = lodash_1.default.concat(currentStagedAttachments, newAttachments);
            const uniqAttachments = lodash_1.default.uniqBy(allAttachments, m => m.fileName);
            state.stagedAttachments[conversationKey] = uniqAttachments;
            return state;
        },
        removeAllStagedAttachmentsInConversation(state, action) {
            const { conversationKey } = action.payload;
            const currentStagedAttachments = state.stagedAttachments[conversationKey];
            if (!currentStagedAttachments || lodash_1.default.isEmpty(currentStagedAttachments)) {
                return state;
            }
            currentStagedAttachments.forEach(attachment => {
                if (attachment.url) {
                    URL.revokeObjectURL(attachment.url);
                }
                if (attachment.videoUrl) {
                    URL.revokeObjectURL(attachment.videoUrl);
                }
            });
            delete state.stagedAttachments[conversationKey];
            return state;
        },
        removeStagedAttachmentInConversation(state, action) {
            const { conversationKey, filename } = action.payload;
            const currentStagedAttachments = state.stagedAttachments[conversationKey];
            if (!currentStagedAttachments || lodash_1.default.isEmpty(currentStagedAttachments)) {
                return state;
            }
            const attachmentToRemove = currentStagedAttachments.find(m => m.fileName === filename);
            if (!attachmentToRemove) {
                return state;
            }
            if (attachmentToRemove.url) {
                URL.revokeObjectURL(attachmentToRemove.url);
            }
            if (attachmentToRemove.videoUrl) {
                URL.revokeObjectURL(attachmentToRemove.videoUrl);
            }
            state.stagedAttachments[conversationKey] = state.stagedAttachments[conversationKey].filter(a => a.fileName !== filename);
            return state;
        },
    },
});
exports.actions = stagedAttachmentsSlice.actions, exports.reducer = stagedAttachmentsSlice.reducer;
exports.addStagedAttachmentsInConversation = exports.actions.addStagedAttachmentsInConversation, exports.removeAllStagedAttachmentsInConversation = exports.actions.removeAllStagedAttachmentsInConversation, exports.removeStagedAttachmentInConversation = exports.actions.removeStagedAttachmentInConversation;
