"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reducer = exports.actions = void 0;
exports.actions = {
    userChanged,
};
function userChanged(attributes) {
    return {
        type: 'USER_CHANGED',
        payload: attributes,
    };
}
function getEmptyState() {
    return {
        ourNumber: 'missing',
    };
}
function reducer(state, action) {
    if (!state) {
        return getEmptyState();
    }
    if (action.type === 'USER_CHANGED') {
        const { payload } = action;
        return {
            ...state,
            ...payload,
        };
    }
    return state;
}
exports.reducer = reducer;
