"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.walletConfigReducer = exports.updateWalletPaymentDetailsSend = exports.updateWalletPasswordPopUpFlag = exports.updatewalletSyncBarShowInChat = exports.updateWalletRescaning = exports.updateWalletHeight = exports.updateDecimalValue = exports.updateFiatBalance = exports.updateSendAddress = exports.reducer = exports.actions = exports.initialWalletConfigState = void 0;
const toolkit_1 = require("@reduxjs/toolkit");
const settings_key_1 = require("../../data/settings-key");
const chatwithWallet = window.getSettingValue(settings_key_1.SettingsKey.settingsChatWithWallet) || true;
exports.initialWalletConfigState = {
    walletsendAddress: '',
    fiatBalance: '',
    walletHeight: '',
    walletDecimalValue: '2 - Two (0.00)',
    walletRescaning: false,
    WalletSyncInitiatedWithChat: chatwithWallet,
    walletSyncBarShowInChat: false,
    walletPasswordPopUpFlag: true,
    walletPaymentDetailsSend: null,
};
const walletConfigSlice = (0, toolkit_1.createSlice)({
    name: 'walletConfig',
    initialState: exports.initialWalletConfigState,
    reducers: {
        updateSendAddress(state, action) {
            return { ...state, walletsendAddress: action.payload };
        },
        updateFiatBalance(state, action) {
            return { ...state, fiatBalance: action.payload };
        },
        updateDecimalValue(state, action) {
            return { ...state, walletDecimalValue: action.payload };
        },
        updateWalletHeight(state, action) {
            return { ...state, walletHeight: action.payload };
        },
        updateWalletRescaning(state, action) {
            return { ...state, walletRescaning: action.payload };
        },
        updatewalletSyncBarShowInChat(state, action) {
            return { ...state, walletSyncBarShowInChat: action.payload };
        },
        updateWalletPasswordPopUpFlag(state, action) {
            return { ...state, walletPasswordPopUpFlag: action.payload };
        },
        updateWalletPaymentDetailsSend(state, action) {
            return { ...state, walletPaymentDetailsSend: action.payload };
        },
    },
});
exports.actions = walletConfigSlice.actions, exports.reducer = walletConfigSlice.reducer;
exports.updateSendAddress = exports.actions.updateSendAddress, exports.updateFiatBalance = exports.actions.updateFiatBalance, exports.updateDecimalValue = exports.actions.updateDecimalValue, exports.updateWalletHeight = exports.actions.updateWalletHeight, exports.updateWalletRescaning = exports.actions.updateWalletRescaning, exports.updatewalletSyncBarShowInChat = exports.actions.updatewalletSyncBarShowInChat, exports.updateWalletPasswordPopUpFlag = exports.actions.updateWalletPasswordPopUpFlag, exports.updateWalletPaymentDetailsSend = exports.actions.updateWalletPaymentDetailsSend;
exports.walletConfigReducer = exports.reducer;
