"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCallIsInFullScreen = exports.getHasOngoingCallWithNonFocusedConvo = exports.getCallWithFocusedConvosIsConnected = exports.getCallWithFocusedConvosIsConnecting = exports.getCallWithFocusedConvoIsOffering = exports.getHasOngoingCallWithFocusedConvo = exports.getHasOngoingCallWithPubkey = exports.getHasOngoingCall = exports.getHasOngoingCallWith = exports.getHasIncomingCall = exports.getHasIncomingCallFrom = exports.getCallState = void 0;
const reselect_1 = require("reselect");
const conversations_1 = require("./conversations");
const getCallState = (state) => state.call;
exports.getCallState = getCallState;
exports.getHasIncomingCallFrom = (0, reselect_1.createSelector)(exports.getCallState, (state) => {
    return state.ongoingWith && state.ongoingCallStatus === 'incoming'
        ? state.ongoingWith
        : undefined;
});
exports.getHasIncomingCall = (0, reselect_1.createSelector)(exports.getHasIncomingCallFrom, (withConvo) => !!withConvo);
exports.getHasOngoingCallWith = (0, reselect_1.createSelector)(conversations_1.getConversations, exports.getCallState, (convos, callState) => {
    if (callState.ongoingWith &&
        (callState.ongoingCallStatus === 'connecting' ||
            callState.ongoingCallStatus === 'offering' ||
            callState.ongoingCallStatus === 'ongoing')) {
        return convos.conversationLookup[callState.ongoingWith] || undefined;
    }
    return undefined;
});
exports.getHasOngoingCall = (0, reselect_1.createSelector)(exports.getHasOngoingCallWith, (withConvo) => !!withConvo);
exports.getHasOngoingCallWithPubkey = (0, reselect_1.createSelector)(exports.getHasOngoingCallWith, (withConvo) => withConvo?.id);
exports.getHasOngoingCallWithFocusedConvo = (0, reselect_1.createSelector)(exports.getHasOngoingCallWithPubkey, conversations_1.getSelectedConversationKey, (withPubkey, selectedPubkey) => {
    return withPubkey && withPubkey === selectedPubkey;
});
const getCallStateWithFocusedConvo = (0, reselect_1.createSelector)(exports.getCallState, conversations_1.getSelectedConversationKey, (callState) => {
    if (callState.ongoingWith) {
        return callState.ongoingCallStatus;
    }
    return undefined;
});
exports.getCallWithFocusedConvoIsOffering = (0, reselect_1.createSelector)(getCallStateWithFocusedConvo, (callState) => {
    return callState === 'offering';
});
exports.getCallWithFocusedConvosIsConnecting = (0, reselect_1.createSelector)(getCallStateWithFocusedConvo, (callState) => {
    return callState === 'connecting';
});
exports.getCallWithFocusedConvosIsConnected = (0, reselect_1.createSelector)(getCallStateWithFocusedConvo, (callState) => {
    return callState === 'ongoing';
});
exports.getHasOngoingCallWithNonFocusedConvo = (0, reselect_1.createSelector)(exports.getHasOngoingCallWithPubkey, conversations_1.getSelectedConversationKey, (withPubkey, selectedPubkey) => {
    return withPubkey && withPubkey !== selectedPubkey;
});
exports.getCallIsInFullScreen = (0, reselect_1.createSelector)(exports.getCallState, (callState) => callState.callIsInFullScreen);
