"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMostRecentMessageId = exports.getMentionsInput = exports.getNextMessageToPlayId = exports.getShouldHighlightMessage = exports.getQuotedMessageToAnimate = exports.getShowScrollButton = exports.areMoreMessagesBeingFetched = exports.getQuotedMessage = exports.getLightBoxOptions = exports.getSelectedMessageIds = exports.isMessageSelectionMode = exports.getViewContactPanel = exports.isShareContact = exports.isRightPanelShowing = exports.getMessageDetailsViewProps = exports.isMessageDetailView = exports.getNumberOfPinnedConversations = exports.getIsSelectedNoteToSelf = exports.getIsSelectedBlocked = exports.getIsSelectedPrivate = exports.getCurrentNotificationSettingText = exports.getConversationHeaderTitleProps = exports.getUnreadMessageCount = exports.getDirectContacts = exports.getMe = exports.getLeftPaneLists = exports.getPrivateAndBlockedContactsPubkeys = exports.getPrivateContactsPubkeys = exports.getUnreadConversationRequests = exports.getConversationRequests = exports.getSortedConversations = exports._getSortedConversations = exports._getLeftPaneLists = exports.getConversationComparator = exports._getConversationComparator = exports.getSortedMessagesTypesOfSelectedConversation = exports.getConversationHasUnread = exports.getSortedMessagesOfSelectedConversation = exports.getOurPrimaryConversation = exports.isPublicGroupConversation = exports.isClosedGroupConversation = exports.isGroupConversation = exports.getIsTypingEnabled = exports.getSelectedConversationIsPublic = exports.getSelectedConversation = exports.getSelectedConversationKey = exports.getBlockedPubkeys = exports.getConversationsCount = exports.getConversationLookup = exports.getConversations = void 0;
exports.getOldBottomMessageId = exports.getOldTopMessageId = exports.getGenericReadableMessageSelectorProps = exports.getMessageContentWithStatusesSelectorProps = exports.getMessageContentSelectorProps = exports.getIsMessageSelected = exports.getMessageAttachmentProps = exports.getMessageIsDeletable = exports.getMessageAuthorProps = exports.getMessageContextMenuProps = exports.getMessageTextProps = exports.getMessageStatusProps = exports.getMessageQuoteProps = exports.getMessagePreviewProps = exports.getMessageReactsProps = exports.getMessageAvatarProps = exports.getMessagePropsByMessageId = exports.isFirstUnreadMessageIdAbove = exports.getLoadedMessagesLength = exports.getYoungestMessageId = exports.getOldestMessageId = void 0;
const reselect_1 = require("reselect");
const user_1 = require("./user");
const util_1 = require("../../util");
const conversation_1 = require("../../models/conversation");
const conversations_1 = require("../../bchat/conversations");
const utils_1 = require("../../bchat/utils");
const storage_1 = require("../../util/storage");
const lodash_1 = require("lodash");
const moment_1 = __importDefault(require("moment"));
const getConversations = (state) => state.conversations;
exports.getConversations = getConversations;
exports.getConversationLookup = (0, reselect_1.createSelector)(exports.getConversations, (state) => {
    return state.conversationLookup;
});
exports.getConversationsCount = (0, reselect_1.createSelector)(exports.getConversationLookup, (state) => {
    return Object.values(state).length;
});
exports.getBlockedPubkeys = (0, reselect_1.createSelector)(exports.getConversationLookup, (_state) => {
    return util_1.BlockedNumberController.getBlockedNumbers();
});
exports.getSelectedConversationKey = (0, reselect_1.createSelector)(exports.getConversations, (state) => {
    return state.selectedConversation;
});
exports.getSelectedConversation = (0, reselect_1.createSelector)(exports.getConversations, (state) => {
    return state.selectedConversation
        ? state.conversationLookup[state.selectedConversation]
        : undefined;
});
exports.getSelectedConversationIsPublic = (0, reselect_1.createSelector)(exports.getSelectedConversation, (state) => {
    return state?.isPublic || false;
});
exports.getIsTypingEnabled = (0, reselect_1.createSelector)(exports.getConversations, exports.getSelectedConversationKey, (state, selectedConvoPubkey) => {
    if (!selectedConvoPubkey) {
        return false;
    }
    const selectedConvo = state.conversationLookup[selectedConvoPubkey];
    if (!selectedConvo) {
        return false;
    }
    const { isBlocked, isKickedFromGroup, left } = selectedConvo;
    return !(isBlocked || isKickedFromGroup || left);
});
exports.isGroupConversation = (0, reselect_1.createSelector)(exports.getSelectedConversation, (state) => {
    return state?.type === 'group' || false;
});
exports.isClosedGroupConversation = (0, reselect_1.createSelector)(exports.getSelectedConversation, (state) => {
    return (state?.type === 'group' && !state.isPublic) || false;
});
exports.isPublicGroupConversation = (0, reselect_1.createSelector)(exports.getSelectedConversation, (state) => {
    return (state?.type === 'group' && state.isPublic) || false;
});
exports.getOurPrimaryConversation = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.conversationLookup[storage_1.Storage.get('primaryDevicePubKey')]);
const getMessagesOfSelectedConversation = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.messages);
exports.getSortedMessagesOfSelectedConversation = (0, reselect_1.createSelector)(getMessagesOfSelectedConversation, (messages) => {
    if (messages.length === 0) {
        return [];
    }
    const convoId = messages[0].propsForMessage.convoId;
    const convo = (0, conversations_1.getConversationController)().get(convoId);
    if (!convo) {
        return [];
    }
    const isPublic = convo.isPublic() || false;
    const sortedMessage = sortMessages(messages, isPublic);
    return updateFirstMessageOfSeries(sortedMessage);
});
const getFirstUnreadMessageId = (0, reselect_1.createSelector)(exports.getConversations, (state) => {
    return state.firstUnreadMessageId;
});
exports.getConversationHasUnread = (0, reselect_1.createSelector)(getFirstUnreadMessageId, unreadId => {
    return Boolean(unreadId);
});
exports.getSortedMessagesTypesOfSelectedConversation = (0, reselect_1.createSelector)(exports.getSortedMessagesOfSelectedConversation, getFirstUnreadMessageId, (sortedMessages, firstUnreadId) => {
    return sortedMessages.map((msg, index) => {
        const isFirstUnread = Boolean(firstUnreadId === msg.propsForMessage.id);
        const messageTimestamp = msg.propsForMessage.serverTimestamp || msg.propsForMessage.timestamp;
        const previousMessageTimestamp = index + 1 >= sortedMessages.length
            ? Number.MAX_SAFE_INTEGER
            : sortedMessages[index + 1].propsForMessage.serverTimestamp ||
                sortedMessages[index + 1].propsForMessage.timestamp;
        const isSameDay = (0, moment_1.default)(messageTimestamp).isSame((0, moment_1.default)(previousMessageTimestamp), 'day');
        const showDateBreak = !isSameDay ? messageTimestamp : undefined;
        if (msg.propsForDataExtractionNotification) {
            return {
                showUnreadIndicator: isFirstUnread,
                showDateBreak,
                message: {
                    messageType: 'data-extraction',
                    props: { ...msg.propsForDataExtractionNotification, messageId: msg.propsForMessage.id },
                },
            };
        }
        if (msg.propsForMessageRequestResponse) {
            return {
                showUnreadIndicator: isFirstUnread,
                showDateBreak,
                message: {
                    messageType: 'message-request-response',
                    props: { ...msg.propsForMessageRequestResponse, messageId: msg.propsForMessage.id },
                },
            };
        }
        if (msg.propsForGroupInvitation) {
            return {
                showUnreadIndicator: isFirstUnread,
                showDateBreak,
                message: {
                    messageType: 'group-invitation',
                    props: { ...msg.propsForGroupInvitation, messageId: msg.propsForMessage.id },
                },
            };
        }
        if (msg.propsForPayment) {
            return {
                showUnreadIndicator: isFirstUnread,
                showDateBreak,
                message: {
                    messageType: 'payment',
                    props: { ...msg.propsForPayment, messageId: msg.propsForMessage.id },
                },
            };
        }
        if (msg.propsForSharedContact) {
            return {
                showUnreadIndicator: isFirstUnread,
                showDateBreak,
                message: {
                    messageType: 'shared-contact',
                    props: { ...msg.propsForSharedContact, messageId: msg.propsForMessage.id },
                },
            };
        }
        if (msg.propsForGroupUpdateMessage) {
            return {
                showUnreadIndicator: isFirstUnread,
                showDateBreak,
                message: {
                    messageType: 'group-notification',
                    props: { ...msg.propsForGroupUpdateMessage, messageId: msg.propsForMessage.id },
                },
            };
        }
        if (msg.propsForTimerNotification) {
            return {
                showUnreadIndicator: isFirstUnread,
                showDateBreak,
                message: {
                    messageType: 'timer-notification',
                    props: { ...msg.propsForTimerNotification, messageId: msg.propsForMessage.id },
                },
            };
        }
        if (msg.propsForCallNotification) {
            return {
                showUnreadIndicator: isFirstUnread,
                showDateBreak,
                message: {
                    messageType: 'call-notification',
                    props: {
                        ...msg.propsForCallNotification,
                        messageId: msg.propsForMessage.id,
                    },
                },
            };
        }
        return {
            showUnreadIndicator: isFirstUnread,
            showDateBreak,
            message: {
                messageType: 'regular-message',
                props: { messageId: msg.propsForMessage.id },
            },
        };
    });
});
function getConversationTitle(conversation, testingi18n) {
    if (conversation.name) {
        return conversation.name;
    }
    if (conversation.type === 'group') {
        return (testingi18n || window.i18n)('unknown');
    }
    return conversation.id;
}
const collator = new Intl.Collator();
const _getConversationComparator = (testingi18n) => {
    return (left, right) => {
        if (left.isPinned && !right.isPinned) {
            return -1;
        }
        if (!left.isPinned && right.isPinned) {
            return 1;
        }
        const leftActiveAt = left.activeAt;
        const rightActiveAt = right.activeAt;
        if (leftActiveAt && !rightActiveAt) {
            return -1;
        }
        if (rightActiveAt && !leftActiveAt) {
            return 1;
        }
        if (leftActiveAt && rightActiveAt && leftActiveAt !== rightActiveAt) {
            return rightActiveAt - leftActiveAt;
        }
        const leftTitle = getConversationTitle(left, testingi18n).toLowerCase();
        const rightTitle = getConversationTitle(right, testingi18n).toLowerCase();
        return collator.compare(leftTitle, rightTitle);
    };
};
exports._getConversationComparator = _getConversationComparator;
exports.getConversationComparator = (0, reselect_1.createSelector)(user_1.getIntl, exports._getConversationComparator);
const _getLeftPaneLists = (sortedConversations) => {
    const conversations = [];
    const directConversations = [];
    let unreadCount = 0;
    for (const conversation of sortedConversations) {
        if (conversation.activeAt !== undefined &&
            conversation.type === conversation_1.ConversationTypeEnum.PRIVATE &&
            conversation.isApproved &&
            !conversation.isBlocked) {
            directConversations.push(conversation);
        }
        if (!conversation.isApproved && conversation.isPrivate) {
            continue;
        }
        if (conversation.isBlocked) {
            continue;
        }
        if (unreadCount < 9 &&
            conversation.unreadCount &&
            conversation.unreadCount > 0 &&
            conversation.currentNotificationSetting !== 'disabled') {
            unreadCount += conversation.unreadCount;
        }
        conversations.push(conversation);
    }
    return {
        conversations,
        contacts: directConversations,
        unreadCount,
    };
};
exports._getLeftPaneLists = _getLeftPaneLists;
const _getSortedConversations = (lookup, comparator, selectedConversation) => {
    const values = Object.values(lookup);
    const sorted = values.sort(comparator);
    const sortedConversations = [];
    for (let conversation of sorted) {
        if (selectedConversation === conversation.id) {
            conversation = {
                ...conversation,
                isSelected: true,
            };
        }
        const isBlocked = util_1.BlockedNumberController.isBlocked(conversation.id) ||
            util_1.BlockedNumberController.isGroupBlocked(conversation.id);
        if (isBlocked) {
            conversation = {
                ...conversation,
                isBlocked: true,
            };
        }
        if (conversation.isPublic && (!conversation.name || conversation.name === 'Unknown group')) {
            continue;
        }
        if (!conversation.isPublic && !conversation.activeAt) {
            continue;
        }
        sortedConversations.push(conversation);
    }
    return sortedConversations;
};
exports._getSortedConversations = _getSortedConversations;
exports.getSortedConversations = (0, reselect_1.createSelector)(exports.getConversationLookup, exports.getConversationComparator, exports.getSelectedConversationKey, exports._getSortedConversations);
const _getConversationRequests = (sortedConversations) => {
    return (0, lodash_1.filter)(sortedConversations, conversation => {
        const { isApproved, isBlocked, isPrivate, isMe } = conversation;
        const isRequest = conversation_1.ConversationModel.hasValidIncomingRequestValues({
            isApproved,
            isBlocked,
            isPrivate,
            isMe,
        });
        return isRequest;
    });
};
exports.getConversationRequests = (0, reselect_1.createSelector)(exports.getSortedConversations, _getConversationRequests);
const _getUnreadConversationRequests = (sortedConversationRequests) => {
    return (0, lodash_1.filter)(sortedConversationRequests, conversation => {
        return conversation && conversation.unreadCount && conversation.unreadCount > 0;
    });
};
exports.getUnreadConversationRequests = (0, reselect_1.createSelector)(exports.getConversationRequests, _getUnreadConversationRequests);
const _getPrivateContactsPubkeys = (sortedConversations) => {
    return (0, lodash_1.filter)(sortedConversations, conversation => {
        return (conversation.isPrivate &&
            !conversation.isBlocked &&
            !conversation.isMe &&
            conversation.didApproveMe &&
            conversation.isApproved &&
            Boolean(conversation.activeAt));
    }).map(convo => convo.id);
};
const _getPrivateAndBlockedContactsPubkeys = (sortedConversations) => {
    return (0, lodash_1.filter)(sortedConversations, conversation => {
        return (conversation.isPrivate &&
            !conversation.isMe &&
            conversation.didApproveMe &&
            conversation.isApproved &&
            Boolean(conversation.activeAt));
    }).map(convo => convo.id);
};
exports.getPrivateContactsPubkeys = (0, reselect_1.createSelector)(exports.getSortedConversations, _getPrivateContactsPubkeys);
exports.getPrivateAndBlockedContactsPubkeys = (0, reselect_1.createSelector)(exports.getSortedConversations, _getPrivateAndBlockedContactsPubkeys);
exports.getLeftPaneLists = (0, reselect_1.createSelector)(exports.getSortedConversations, exports._getLeftPaneLists);
exports.getMe = (0, reselect_1.createSelector)([exports.getConversationLookup, user_1.getOurNumber], (lookup, ourNumber) => {
    return lookup[ourNumber];
});
exports.getDirectContacts = (0, reselect_1.createSelector)(exports.getLeftPaneLists, (state) => state.contacts);
exports.getUnreadMessageCount = (0, reselect_1.createSelector)(exports.getLeftPaneLists, (state) => {
    return state.unreadCount;
});
exports.getConversationHeaderTitleProps = (0, reselect_1.createSelector)(exports.getSelectedConversation, (state) => {
    if (!state) {
        return undefined;
    }
    return {
        isKickedFromGroup: !!state.isKickedFromGroup,
        conversationKey: state.id,
        isMe: !!state.isMe,
        members: state.members || [],
        isPublic: !!state.isPublic,
        profileName: state.profileName,
        name: state.name,
        subscriberCount: state.subscriberCount,
        isGroup: state.type === 'group',
        currentNotificationSetting: state.currentNotificationSetting,
    };
});
exports.getCurrentNotificationSettingText = (0, reselect_1.createSelector)(exports.getSelectedConversation, (state) => {
    if (!state) {
        return undefined;
    }
    switch (state.currentNotificationSetting) {
        case 'all':
            return window.i18n('notificationForConvo_all');
        case 'mentions_only':
            return window.i18n('notificationForConvo_mentions_only');
        case 'disabled':
            return window.i18n('notificationForConvo_disabled');
        default:
            return window.i18n('notificationForConvo_all');
    }
});
exports.getIsSelectedPrivate = (0, reselect_1.createSelector)(exports.getSelectedConversation, (selectedProps) => {
    return selectedProps?.isPrivate || false;
});
exports.getIsSelectedBlocked = (0, reselect_1.createSelector)(exports.getSelectedConversation, (selectedProps) => {
    return selectedProps?.isBlocked || false;
});
exports.getIsSelectedNoteToSelf = (0, reselect_1.createSelector)(exports.getSelectedConversation, (selectedProps) => {
    return selectedProps?.isMe || false;
});
exports.getNumberOfPinnedConversations = (0, reselect_1.createSelector)(exports.getConversations, (state) => {
    const values = Object.values(state.conversationLookup);
    return values.filter(conversation => conversation.isPinned).length;
});
exports.isMessageDetailView = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.messageDetailProps !== undefined);
exports.getMessageDetailsViewProps = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.messageDetailProps);
exports.isRightPanelShowing = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.showRightPanel);
exports.isShareContact = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.showShareContact);
exports.getViewContactPanel = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.showViewContactPanel);
exports.isMessageSelectionMode = (0, reselect_1.createSelector)(exports.getConversations, (state) => Boolean(state.selectedMessageIds.length > 0));
exports.getSelectedMessageIds = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.selectedMessageIds);
exports.getLightBoxOptions = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.lightBox);
exports.getQuotedMessage = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.quotedMessage);
exports.areMoreMessagesBeingFetched = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.areMoreMessagesBeingFetched || false);
exports.getShowScrollButton = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.showScrollButton || false);
exports.getQuotedMessageToAnimate = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.animateQuotedMessageId || undefined);
exports.getShouldHighlightMessage = (0, reselect_1.createSelector)(exports.getConversations, (state) => Boolean(state.animateQuotedMessageId && state.shouldHighlightMessage));
exports.getNextMessageToPlayId = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.nextMessageToPlayId || undefined);
exports.getMentionsInput = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.mentionMembers);
function updateFirstMessageOfSeries(messageModelsProps) {
    const sortedMessageProps = [];
    for (let i = 0; i < messageModelsProps.length; i++) {
        const currentSender = messageModelsProps[i].propsForMessage?.sender;
        const previousSender = i < messageModelsProps.length - 1
            ? messageModelsProps[i + 1].propsForMessage?.sender
            : undefined;
        const nextSender = i > 0 ? messageModelsProps[i - 1].propsForMessage?.sender : undefined;
        sortedMessageProps.push({
            ...messageModelsProps[i],
            firstMessageOfSeries: !(i >= 0 && currentSender === previousSender),
            lastMessageOfSeries: currentSender !== nextSender,
        });
    }
    return sortedMessageProps;
}
function sortMessages(messages, isPublic) {
    if (isPublic) {
        return messages.slice().sort((a, b) => {
            return (b.propsForMessage.serverTimestamp || 0) - (a.propsForMessage.serverTimestamp || 0);
        });
    }
    if (messages.some(n => !n.propsForMessage.timestamp && !n.propsForMessage.receivedAt)) {
        throw new Error('Found some messages without any timestamp set');
    }
    const messagesSorted = messages
        .slice()
        .sort((a, b) => (b.propsForMessage.timestamp || b.propsForMessage.receivedAt || 0) -
        (a.propsForMessage.timestamp || a.propsForMessage.receivedAt || 0));
    return messagesSorted;
}
exports.getMostRecentMessageId = (0, reselect_1.createSelector)(exports.getConversations, (state) => {
    return state.mostRecentMessageId;
});
exports.getOldestMessageId = (0, reselect_1.createSelector)(exports.getSortedMessagesOfSelectedConversation, (messages) => {
    const oldest = messages.length > 0 ? messages[messages.length - 1].propsForMessage.id : undefined;
    return oldest;
});
exports.getYoungestMessageId = (0, reselect_1.createSelector)(exports.getSortedMessagesOfSelectedConversation, (messages) => {
    const youngest = messages.length > 0 ? messages[0].propsForMessage.id : undefined;
    return youngest;
});
exports.getLoadedMessagesLength = (0, reselect_1.createSelector)(exports.getConversations, (state) => {
    return state.messages.length || 0;
});
exports.isFirstUnreadMessageIdAbove = (0, reselect_1.createSelector)(exports.getConversations, (state) => {
    if (!state.firstUnreadMessageId) {
        return false;
    }
    const isNotPresent = !state.messages.some(m => m.propsForMessage.id === state.firstUnreadMessageId);
    return isNotPresent;
});
const getMessageId = (_whatever, id) => id;
exports.getMessagePropsByMessageId = (0, reselect_1.createSelector)(exports.getConversations, exports.getSortedMessagesOfSelectedConversation, exports.getConversationLookup, getMessageId, (_convoState, messages, conversations, id) => {
    const foundMessageProps = messages?.find(m => m?.propsForMessage?.id === id);
    if (!foundMessageProps || !foundMessageProps.propsForMessage.convoId) {
        return undefined;
    }
    const sender = foundMessageProps?.propsForMessage?.sender;
    const foundMessageConversation = conversations[foundMessageProps.propsForMessage.convoId];
    if (!foundMessageConversation || !sender) {
        return undefined;
    }
    const foundSenderConversation = conversations[sender];
    if (!foundSenderConversation) {
        return undefined;
    }
    const ourPubkey = utils_1.UserUtils.getOurPubKeyStrFromCache();
    const isGroup = !foundMessageConversation.isPrivate;
    const isPublic = foundMessageConversation.isPublic;
    const groupAdmins = (isGroup && foundMessageConversation.groupAdmins) || [];
    const weAreAdmin = groupAdmins.includes(ourPubkey) || false;
    const isDeletable = sender === ourPubkey || !isPublic || (isPublic && !!weAreAdmin);
    const isDeletableForEveryone = sender === ourPubkey || (isPublic && !!weAreAdmin) || false;
    const isSenderAdmin = groupAdmins.includes(sender);
    const senderIsUs = sender === ourPubkey;
    const authorName = foundSenderConversation.name || null;
    const authorProfileName = senderIsUs ? window.i18n('you') : foundSenderConversation.profileName;
    const messageProps = {
        ...foundMessageProps,
        propsForMessage: {
            ...foundMessageProps.propsForMessage,
            isBlocked: !!foundMessageConversation.isBlocked,
            isPublic: !!isPublic,
            isOpenGroupV2: !!isPublic,
            isSenderAdmin,
            isDeletable,
            isDeletableForEveryone,
            weAreAdmin,
            conversationType: foundMessageConversation.type,
            sender,
            authorAvatarPath: foundSenderConversation.avatarPath || null,
            isKickedFromGroup: foundMessageConversation.isKickedFromGroup || false,
            authorProfileName: authorProfileName || 'Unknown',
            authorName,
        },
    };
    return messageProps;
});
exports.getMessageAvatarProps = (0, reselect_1.createSelector)(exports.getMessagePropsByMessageId, (props) => {
    if (!props || (0, lodash_1.isEmpty)(props)) {
        return undefined;
    }
    const messageAvatarProps = {
        lastMessageOfSeries: props.lastMessageOfSeries,
        ...(0, lodash_1.pick)(props.propsForMessage, [
            'authorAvatarPath',
            'authorName',
            'sender',
            'authorProfileName',
            'conversationType',
            'direction',
            'isPublic',
            'isSenderAdmin',
        ]),
    };
    return messageAvatarProps;
});
exports.getMessageReactsProps = (0, reselect_1.createSelector)(exports.getMessagePropsByMessageId, (props) => {
    if (!props || (0, lodash_1.isEmpty)(props)) {
        return undefined;
    }
    const msgProps = (0, lodash_1.pick)(props.propsForMessage, [
        'convoId',
        'conversationType',
        'isPublic',
        'reacts',
        'serverId',
    ]);
    if (msgProps.reacts) {
        const sortedReacts = Object.entries(msgProps.reacts).sort((a, b) => {
            return a[1].index < b[1].index ? -1 : a[1].index > b[1].index ? 1 : 0;
        });
        msgProps.sortedReacts = sortedReacts;
    }
    return msgProps;
});
exports.getMessagePreviewProps = (0, reselect_1.createSelector)(exports.getMessagePropsByMessageId, (props) => {
    if (!props || (0, lodash_1.isEmpty)(props)) {
        return undefined;
    }
    const msgProps = (0, lodash_1.pick)(props.propsForMessage, [
        'attachments',
        'previews',
    ]);
    return msgProps;
});
exports.getMessageQuoteProps = (0, reselect_1.createSelector)(exports.getMessagePropsByMessageId, (props) => {
    if (!props || (0, lodash_1.isEmpty)(props)) {
        return undefined;
    }
    const msgProps = (0, lodash_1.pick)(props.propsForMessage, ['direction', 'quote']);
    return msgProps;
});
exports.getMessageStatusProps = (0, reselect_1.createSelector)(exports.getMessagePropsByMessageId, (props) => {
    if (!props || (0, lodash_1.isEmpty)(props)) {
        return undefined;
    }
    const msgProps = (0, lodash_1.pick)(props.propsForMessage, ['direction', 'status']);
    return msgProps;
});
exports.getMessageTextProps = (0, reselect_1.createSelector)(exports.getMessagePropsByMessageId, (props) => {
    if (!props || (0, lodash_1.isEmpty)(props)) {
        return undefined;
    }
    const msgProps = (0, lodash_1.pick)(props.propsForMessage, [
        'direction',
        'status',
        'text',
        'isDeleted',
        'conversationType',
    ]);
    return msgProps;
});
exports.getMessageContextMenuProps = (0, reselect_1.createSelector)(exports.getMessagePropsByMessageId, (props) => {
    if (!props || (0, lodash_1.isEmpty)(props)) {
        return undefined;
    }
    const msgProps = (0, lodash_1.pick)(props.propsForMessage, [
        'attachments',
        'sender',
        'convoId',
        'direction',
        'status',
        'isDeletable',
        'isPublic',
        'isOpenGroupV2',
        'weAreAdmin',
        'isSenderAdmin',
        'text',
        'serverTimestamp',
        'timestamp',
        'isBlocked',
        'isDeletableForEveryone',
        'isDeleted'
    ]);
    return msgProps;
});
exports.getMessageAuthorProps = (0, reselect_1.createSelector)(exports.getMessagePropsByMessageId, (props) => {
    if (!props || (0, lodash_1.isEmpty)(props)) {
        return undefined;
    }
    const msgProps = {
        firstMessageOfSeries: props.firstMessageOfSeries,
        ...(0, lodash_1.pick)(props.propsForMessage, ['authorName', 'sender', 'authorProfileName', 'direction']),
    };
    return msgProps;
});
exports.getMessageIsDeletable = (0, reselect_1.createSelector)(exports.getMessagePropsByMessageId, (props) => {
    if (!props || (0, lodash_1.isEmpty)(props)) {
        return false;
    }
    return props.propsForMessage.isDeletable;
});
exports.getMessageAttachmentProps = (0, reselect_1.createSelector)(exports.getMessagePropsByMessageId, (props) => {
    if (!props || (0, lodash_1.isEmpty)(props)) {
        return undefined;
    }
    const msgProps = {
        attachments: props.propsForMessage.attachments || [],
        ...(0, lodash_1.pick)(props.propsForMessage, [
            'direction',
            'isTrustedForAttachmentDownload',
            'timestamp',
            'serverTimestamp',
            'sender',
            'convoId',
        ]),
    };
    return msgProps;
});
exports.getIsMessageSelected = (0, reselect_1.createSelector)(exports.getMessagePropsByMessageId, exports.getSelectedMessageIds, (props, selectedIds) => {
    if (!props || (0, lodash_1.isEmpty)(props)) {
        return false;
    }
    const { id } = props.propsForMessage;
    return selectedIds.includes(id);
});
exports.getMessageContentSelectorProps = (0, reselect_1.createSelector)(exports.getMessagePropsByMessageId, (props) => {
    if (!props || (0, lodash_1.isEmpty)(props)) {
        return undefined;
    }
    const msgProps = {
        firstMessageOfSeries: props.firstMessageOfSeries,
        lastMessageOfSeries: props.lastMessageOfSeries,
        ...(0, lodash_1.pick)(props.propsForMessage, [
            'direction',
            'serverTimestamp',
            'text',
            'timestamp',
            'previews',
            'quote',
            'attachments',
            'reacts'
        ]),
    };
    return msgProps;
});
exports.getMessageContentWithStatusesSelectorProps = (0, reselect_1.createSelector)(exports.getMessagePropsByMessageId, (props) => {
    if (!props || (0, lodash_1.isEmpty)(props)) {
        return undefined;
    }
    const msgProps = {
        hasAttachments: Boolean(props.propsForMessage.attachments?.length) || false,
        ...(0, lodash_1.pick)(props.propsForMessage, ['direction', 'isDeleted', 'isTrustedForAttachmentDownload', "isPublic",]),
    };
    return msgProps;
});
exports.getGenericReadableMessageSelectorProps = (0, reselect_1.createSelector)(exports.getMessagePropsByMessageId, (props) => {
    if (!props || (0, lodash_1.isEmpty)(props)) {
        return undefined;
    }
    const msgProps = (0, lodash_1.pick)(props.propsForMessage, [
        'direction',
        'conversationType',
        'expirationLength',
        'expirationTimestamp',
        'isUnread',
        'isExpired',
        'convoId',
        'receivedAt',
        'isKickedFromGroup',
        'isDeleted',
    ]);
    return msgProps;
});
exports.getOldTopMessageId = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.oldTopMessageId || null);
exports.getOldBottomMessageId = (0, reselect_1.createSelector)(exports.getConversations, (state) => state.oldBottomMessageId || null);
