"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSearchResults = exports.isSearching = exports.getQuery = exports.getSearch = void 0;
const lodash_1 = require("lodash");
const reselect_1 = require("reselect");
const conversations_1 = require("./conversations");
const getSearch = (state) => state.search;
exports.getSearch = getSearch;
exports.getQuery = (0, reselect_1.createSelector)(exports.getSearch, (state) => state.query);
exports.isSearching = (0, reselect_1.createSelector)(exports.getSearch, (state) => {
    const { query } = state;
    return Boolean(query && query.trim().length > 1);
});
exports.getSearchResults = (0, reselect_1.createSelector)([exports.getSearch, conversations_1.getConversationLookup, conversations_1.getSelectedConversationKey], (searchState, lookup, selectedConversation) => {
    return {
        contactsAndGroups: (0, lodash_1.compact)(searchState.contactsAndGroups.map(id => {
            const value = lookup[id];
            if (!value) {
                return null;
            }
            if (value.activeAt === undefined || value.activeAt === 0) {
                return null;
            }
            if (value && id === selectedConversation) {
                return {
                    ...value,
                    isSelected: true,
                };
            }
            return value;
        })),
        messages: (0, lodash_1.compact)(searchState.messages),
        searchTerm: searchState.query,
    };
});
