"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmartBchatConversation = void 0;
const react_redux_1 = require("react-redux");
const actions_1 = require("../actions");
const theme_1 = require("../selectors/theme");
const conversations_1 = require("../selectors/conversations");
const user_1 = require("../selectors/user");
const stagedAttachments_1 = require("../selectors/stagedAttachments");
const call_1 = require("../selectors/call");
const BchatConversation_1 = require("../../components/conversation/BchatConversation");
const section_1 = require("../selectors/section");
const modal_1 = require("../selectors/modal");
const mapStateToProps = (state) => {
    return {
        selectedConversation: (0, conversations_1.getSelectedConversation)(state),
        selectedConversationKey: (0, conversations_1.getSelectedConversationKey)(state),
        theme: (0, theme_1.getTheme)(state),
        messagesProps: (0, conversations_1.getSortedMessagesOfSelectedConversation)(state),
        ourNumber: (0, user_1.getOurNumber)(state),
        showMessageDetails: (0, conversations_1.isMessageDetailView)(state),
        isRightPanelShowing: (0, conversations_1.isRightPanelShowing)(state),
        selectedMessages: (0, conversations_1.getSelectedMessageIds)(state),
        lightBoxOptions: (0, conversations_1.getLightBoxOptions)(state),
        stagedAttachments: (0, stagedAttachments_1.getStagedAttachmentsForCurrentConversation)(state),
        hasOngoingCallWithFocusedConvo: (0, call_1.getHasOngoingCallWithFocusedConvo)(state),
        isMe: (0, conversations_1.getIsSelectedNoteToSelf)(state),
        convoList: (0, conversations_1.getLeftPaneLists)(state),
        focusedSection: (0, section_1.getFocusedSection)(state),
        reactListModalstate: (0, modal_1.getReactListDialog)(state),
    };
};
const smart = (0, react_redux_1.connect)(mapStateToProps, actions_1.mapDispatchToProps, (stateProps, dispatchProps, ownProps) => {
    return {
        ...stateProps,
        router: ownProps,
        actions: dispatchProps,
    };
});
exports.SmartBchatConversation = smart(BchatConversation_1.BchatConversation);
