"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const beforeEach_1 = require("./setup/beforeEach");
const new_user_1 = require("./setup/new_user");
const send_message_1 = require("./send_message");
const utils_1 = require("./utils");
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
let windows = [];
test_1.test.afterEach(() => (0, beforeEach_1.forceCloseAllWindows)(windows));
(0, test_1.test)('Block User', async () => {
    const windowLoggedIn = await (0, new_user_1.openAppsAndNewUsers)(2);
    windows = windowLoggedIn.windows;
    const users = windowLoggedIn.users;
    const [windowA, windowB] = windows;
    const [userA, userB] = users;
    await (0, send_message_1.sendNewMessage)(windowA, userB.bchatid, `A -> B: ${Date.now()}`);
    await (0, send_message_1.sendNewMessage)(windowB, userA.bchatid, `B -> A: ${Date.now()}`);
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'contact-section');
    await (0, utils_1.waitForTestIdWithText)(windowA, 'module-conversation__user__profile-name', userB.userName);
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'message-section');
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'three-dots-conversation-options');
    await (0, utils_1.clickOnMatchingText)(windowA, 'Block');
    await (0, utils_1.waitForTestIdWithText)(windowA, 'bchat-toast', 'Blocked');
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'settings-section');
    await (0, utils_1.clickOnMatchingText)(windowA, 'Blocked Contacts');
    const blockedContact = windowA.locator('.bchat-settings-item__title');
    await (0, test_1.expect)(blockedContact).toContainText(userB.userName);
    await (0, utils_1.clickOnMatchingText)(windowA, 'Unblock');
    await (0, utils_1.waitForTestIdWithText)(windowA, 'bchat-toast', 'Unblocked');
});
