"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const open_1 = require("./setup/open");
const beforeEach_1 = require("./setup/beforeEach");
const new_user_1 = require("./setup/new_user");
const utils_1 = require("./utils");
let window;
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
test_1.test.afterEach(async () => {
    if (window) {
        await (0, beforeEach_1.forceCloseAllWindows)([window]);
    }
});
(0, test_1.test)('Change profile picture/avatar', async () => {
    window = await (0, open_1.openAppAndWait)('1');
    await (0, new_user_1.newUser)(window, 'userA');
    await (0, utils_1.clickOnTestIdWithText)(window, 'leftpane-primary-avatar');
    await (0, utils_1.waitForTestIdWithText)(window, 'copy-button-profile-update', 'Copy');
    await (0, utils_1.clickOnTestIdWithText)(window, 'image-upload-section');
    await (0, utils_1.clickOnTestIdWithText)(window, 'save-button-profile-update');
    await (0, utils_1.waitForTestIdWithText)(window, 'loading-spinner');
    await (0, utils_1.waitForTestIdWithText)(window, 'copy-button-profile-update', 'Copy');
    await (0, utils_1.clickOnTestIdWithText)(window, 'modal-close-button');
    const leftpaneAvatarContainer = await (0, utils_1.waitForTestIdWithText)(window, 'img-leftpane-primary-avatar');
    const screenshot = await leftpaneAvatarContainer.screenshot({
        type: 'jpeg',
    });
    (0, test_1.expect)(screenshot).toMatchSnapshot({ name: 'avatar-updated-blue.jpeg' });
});
