"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const new_user_1 = require("./setup/new_user");
const open_1 = require("./setup/open");
const beforeEach_1 = require("./setup/beforeEach");
const utils_1 = require("./utils");
let window;
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
test_1.test.afterEach(async () => {
    if (window) {
        await (0, beforeEach_1.forceCloseAllWindows)([window]);
    }
});
(0, test_1.test)('Change username', async () => {
    window = await (0, open_1.openAppAndWait)('1');
    await (0, new_user_1.newUser)(window, 'userA');
    await (0, utils_1.clickOnTestIdWithText)(window, 'leftpane-primary-avatar');
    await (0, utils_1.clickOnTestIdWithText)(window, 'edit-profile-icon');
    await (0, utils_1.typeIntoInput)(window, 'profile-name-input', 'new username');
    await window.keyboard.press('Enter');
    await window.isVisible("'Copy'");
    (0, test_1.expect)(await window.innerText('[data-testid=your-profile-name]')).toBe('new username');
    await window.click('.bchat-icon-button.small');
});
