"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const beforeEach_1 = require("./setup/beforeEach");
const new_user_1 = require("./setup/new_user");
const send_message_1 = require("./send_message");
const utils_1 = require("./utils");
const Promise_1 = require("../../bchat/utils/Promise");
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
let windows = [];
test_1.test.afterEach(() => (0, beforeEach_1.forceCloseAllWindows)(windows));
(0, test_1.test)('Delete account from swarm', async () => {
    const testMessage = `A -> B: ${Date.now()}`;
    const testReply = `B -> A: ${Date.now()}`;
    const windowLoggedIn = await (0, new_user_1.openAppsAndNewUsers)(2);
    windows = windowLoggedIn.windows;
    const [windowA, windowB] = windows;
    const [userA, userB] = windowLoggedIn.users;
    await Promise.all([
        (0, send_message_1.sendNewMessage)(windowA, userB.bchatid, testMessage),
        (0, send_message_1.sendNewMessage)(windowB, userA.bchatid, testReply),
    ]);
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'settings-section');
    await (0, utils_1.clickOnMatchingText)(windowA, 'Clear All Data');
    await (0, utils_1.clickOnMatchingText)(windowA, 'Entire Account');
    await (0, utils_1.clickOnMatchingText)(windowA, 'I am sure');
    await windowA.waitForTimeout(7500);
    await (0, Promise_1.sleepFor)(10000, true);
    const restoringWindows = await (0, new_user_1.openAppsNoNewUsers)(1);
    const [restoringWindow] = restoringWindows;
    await (0, utils_1.clickOnTestIdWithText)(restoringWindow, 'restore-using-recovery', 'Restore your account');
    await (0, utils_1.typeIntoInput)(restoringWindow, 'recovery-phrase-input', userA.recoveryPhrase);
    await (0, utils_1.typeIntoInput)(restoringWindow, 'display-name-input', userA.userName);
    await (0, utils_1.clickOnTestIdWithText)(restoringWindow, 'continue-bchat-button');
    const errorDesc = 'Test Message should not be found';
    try {
        const elemShouldNotBeFound = restoringWindow.locator(testMessage);
        if (elemShouldNotBeFound) {
            console.warn('Test message was not found');
            throw new Error(errorDesc);
        }
    }
    catch (e) {
        if (e.message !== errorDesc) {
            throw e;
        }
    }
    await (0, utils_1.clickOnTestIdWithText)(restoringWindow, 'contact-section');
    const errorDesc2 = 'Should not be found';
    try {
        const elemShouldNotBeFound = restoringWindow.locator(userB.userName);
        if (elemShouldNotBeFound) {
            console.warn('Contact not found');
            throw new Error(errorDesc2);
        }
    }
    catch (e) {
        if (e.message !== errorDesc2) {
            throw e;
        }
    }
    await (0, beforeEach_1.forceCloseAllWindows)(restoringWindows);
});
