"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const beforeEach_1 = require("./setup/beforeEach");
const message_1 = require("./message");
const new_user_1 = require("./setup/new_user");
const send_message_1 = require("./send_message");
const utils_1 = require("./utils");
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
let windows = [];
test_1.test.afterEach(() => (0, beforeEach_1.forceCloseAllWindows)(windows));
const testMessage = 'Test-Message- (A -> B) ';
const testReply = 'Reply-Test-Message- (B -> A)';
const sentMessage = `${testMessage}${Date.now()}`;
const sentReplyMessage = `${testReply} :${Date.now()}`;
(0, test_1.test)('Disappearing Messages', async () => {
    const windowLoggedIn = await (0, new_user_1.openAppsAndNewUsers)(2);
    windows = windowLoggedIn.windows;
    const users = windowLoggedIn.users;
    const [windowA, windowB] = windows;
    const [userA, userB] = users;
    await (0, send_message_1.sendNewMessage)(windowA, userB.bchatid, sentMessage);
    await (0, send_message_1.sendNewMessage)(windowB, userA.bchatid, sentReplyMessage);
    await (0, utils_1.waitForReadableMessageWithText)(windowA, 'Your message request has been accepted');
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'conversation-options-avatar');
    await (0, utils_1.clickOnMatchingText)(windowA, 'Disappearing messages');
    await (0, utils_1.clickOnMatchingText)(windowA, '5 seconds');
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'back-button-conversation-options');
    await (0, utils_1.waitForTestIdWithText)(windowA, 'readable-message', 'You set the disappearing message timer to 5 seconds');
    await (0, utils_1.waitForTestIdWithText)(windowA, 'disappearing-messages-indicator', '5 seconds');
    await (0, message_1.messageSent)(windowA, sentMessage);
    const errorDesc = 'Should not be found';
    try {
        const elemShouldNotBeFound = windowA.locator(sentMessage);
        if (elemShouldNotBeFound) {
            console.warn('Sent message not found in window A');
            throw new Error(errorDesc);
        }
    }
    catch (e) {
        if (e.message !== errorDesc) {
            throw e;
        }
    }
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'conversation-options-avatar');
    await (0, utils_1.clickOnMatchingText)(windowA, 'Disappearing messages');
    await (0, utils_1.clickOnMatchingText)(windowA, 'Off');
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'back-button-conversation-options');
    await (0, utils_1.waitForTestIdWithText)(windowA, 'readable-message', 'Disappearing messages have been disabled by you.');
    await (0, utils_1.waitForMatchingText)(windowB, `${userA.userName} set the disappearing message timer to 5 seconds`);
    await (0, utils_1.waitForMatchingText)(windowB, `${userA.userName} disabled disappearing messages`);
    const errorDesc2 = 'Should not be found';
    try {
        const elemShouldNotBeFound = windowA.locator(sentMessage);
        if (elemShouldNotBeFound) {
            console.warn('Sent message not found in window B');
            throw new Error(errorDesc2);
        }
    }
    catch (e) {
        if (e.message !== errorDesc2) {
            throw e;
        }
    }
});
