"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const beforeEach_1 = require("./setup/beforeEach");
const message_1 = require("./message");
const new_user_1 = require("./setup/new_user");
const send_message_1 = require("./send_message");
const utils_1 = require("./utils");
const testGroupName = 'Test Group Name';
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
let windows = [];
test_1.test.afterEach(() => (0, beforeEach_1.forceCloseAllWindows)(windows));
(0, test_1.test)('Create group', async () => {
    const windowLoggedIn = await (0, new_user_1.openAppsAndNewUsers)(3);
    windows = windowLoggedIn.windows;
    const users = windowLoggedIn.users;
    const [windowA, windowB, windowC] = windows;
    const [userA, userB, userC] = users;
    await (0, send_message_1.sendNewMessage)(windowA, userC.bchatid, `A -> C: ${Date.now()}`);
    await Promise.all([
        (0, send_message_1.sendNewMessage)(windowA, userB.bchatid, `A -> B: ${Date.now()}`),
        (0, send_message_1.sendNewMessage)(windowB, userA.bchatid, `B -> A: ${Date.now()}`),
        (0, send_message_1.sendNewMessage)(windowC, userA.bchatid, `C -> A: ${Date.now()}`),
    ]);
    await (0, utils_1.clickOnMatchingText)(windowA, 'New Closed Group');
    await (0, utils_1.typeIntoInput)(windowA, 'new-closed-group-name', testGroupName);
    await (0, utils_1.clickOnMatchingText)(windowA, userB.userName);
    await (0, utils_1.clickOnMatchingText)(windowA, userC.userName);
    await (0, utils_1.clickOnMatchingText)(windowA, 'Done');
    await (0, utils_1.clickOnMatchingText)(windowB, testGroupName);
    await (0, utils_1.waitForTestIdWithText)(windowB, 'header-conversation-name', testGroupName);
    const msgAToGroup = 'A -> Group';
    await (0, message_1.messageSent)(windowA, msgAToGroup);
    await (0, utils_1.clickOnTestIdWithText)(windowB, 'message-section');
    await (0, utils_1.clickOnMatchingText)(windowB, testGroupName);
    await (0, utils_1.waitForReadableMessageWithText)(windowB, msgAToGroup);
    const msgBToGroup = 'B -> Group';
    await (0, message_1.messageSent)(windowB, msgBToGroup);
    await (0, utils_1.clickOnTestIdWithText)(windowC, 'message-section');
    await (0, utils_1.clickOnMatchingText)(windowC, testGroupName);
    await (0, utils_1.waitForReadableMessageWithText)(windowC, msgAToGroup);
    await (0, utils_1.waitForReadableMessageWithText)(windowC, msgBToGroup);
    const msgCToGroup = 'C -> Group';
    await (0, message_1.messageSent)(windowC, msgCToGroup);
    await (0, utils_1.waitForReadableMessageWithText)(windowA, msgBToGroup);
    await (0, utils_1.waitForReadableMessageWithText)(windowA, msgCToGroup);
});
