"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const beforeEach_1 = require("./setup/beforeEach");
const utils_1 = require("./utils");
const rename_group_1 = require("./rename_group");
const leave_group_1 = require("./leave_group");
const create_group_1 = require("./setup/create_group");
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
let windows = [];
test_1.test.afterEach(() => (0, beforeEach_1.forceCloseAllWindows)(windows));
(0, test_1.test)('Group testing', async () => {
    const { windowA, windowB } = await (0, create_group_1.createGroup)('Test Group Name');
    windows = [windowA, windowB];
    await (0, rename_group_1.renameGroup)(windowA, 'Test Group Name', 'newGroupName');
    await (0, utils_1.clickOnMatchingText)(windowB, 'newGroupName');
    await (0, utils_1.waitForMatchingText)(windowB, "Group name is now 'newGroupName'.");
    await (0, rename_group_1.renameGroup)(windowA, 'newGroupName', 'Test Group Name');
    await (0, utils_1.clickOnMatchingText)(windowA, 'Edit group name');
    await windowA.fill('.profile-name-input', '   ');
    await windowA.keyboard.press('Enter');
    const errorMessage = windowA.locator('.error-message');
    await (0, test_1.expect)(errorMessage).toContainText('Please enter a group name');
    await (0, utils_1.clickOnMatchingText)(windowA, 'Cancel');
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'back-button-conversation-options');
    await (0, leave_group_1.leaveGroup)(windowB);
});
