"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const beforeEach_1 = require("./setup/beforeEach");
const linked_device_1 = require("./setup/linked_device");
const utils_1 = require("./utils");
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
const windows = [];
test_1.test.afterEach(() => (0, beforeEach_1.forceCloseAllWindows)(windows));
(0, test_1.test)('linking device', async () => {
    const { windowA1, windowA2, userA } = await (0, linked_device_1.linkedDevice)();
    windows.push(windowA1, windowA2);
    await (0, utils_1.clickOnTestIdWithText)(windowA2, 'leftpane-primary-avatar');
    await (0, utils_1.waitForTestIdWithText)(windowA2, 'your-profile-name', userA.userName);
    await (0, utils_1.waitForTestIdWithText)(windowA2, 'your-bchat-id', userA.bchatid);
    await (0, utils_1.clickOnTestIdWithText)(windowA2, 'modal-close-button');
    const errorDesc = 'Should not be found';
    try {
        const elemShouldNotBeFound = windowA2.locator('[data-testid=reveal-recovery-phrase]');
        if (elemShouldNotBeFound) {
            console.warn('Element not found');
            throw new Error(errorDesc);
        }
    }
    catch (e) {
        if (e.message !== errorDesc) {
            throw e;
        }
    }
    await (0, utils_1.clickOnTestIdWithText)(windowA1, 'leftpane-primary-avatar');
    await (0, utils_1.clickOnTestIdWithText)(windowA1, 'edit-profile-icon');
    const newUsername = 'new-username';
    await (0, utils_1.typeIntoInput)(windowA1, 'profile-name-input', newUsername);
    await windowA1.keyboard.press('Enter');
    await (0, utils_1.clickOnTestIdWithText)(windowA2, 'leftpane-primary-avatar');
    await (0, utils_1.waitForTestIdWithText)(windowA2, 'your-profile-name', userA.userName);
});
