"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const send_message_1 = require("./send_message");
const beforeEach_1 = require("./setup/beforeEach");
const new_user_1 = require("./setup/new_user");
const utils_1 = require("./utils");
const testMessage = 'A -> B';
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
let windows = [];
test_1.test.afterEach(() => (0, beforeEach_1.forceCloseAllWindows)(windows));
test_1.test.describe('Message requests', () => {
    (0, test_1.test)('Message request acceptance', async () => {
        const windowLoggedIn = await (0, new_user_1.openAppsAndNewUsers)(2);
        windows = windowLoggedIn.windows;
        const users = windowLoggedIn.users;
        const [windowA, windowB] = windows;
        const [userA, userB] = users;
        await (0, send_message_1.sendNewMessage)(windowA, userB.bchatid, `${testMessage}${Date.now()}`);
        await (0, utils_1.clickOnTestIdWithText)(windowB, 'message-request-banner');
        await (0, utils_1.clickOnTestIdWithText)(windowB, 'module-conversation__user__profile-name', userA.userName);
        await (0, utils_1.clickOnTestIdWithText)(windowB, 'accept-message-request');
        await (0, utils_1.waitForTestIdWithText)(windowB, 'readable-message', `You have accepted ${userA.userName}'s message request`);
        await (0, utils_1.waitForMatchingText)(windowB, 'No Message Requests Yet!');
    });
    (0, test_1.test)('Message request rejection', async () => {
        const windowLoggedIn = await (0, new_user_1.openAppsAndNewUsers)(2);
        windows = windowLoggedIn.windows;
        const users = windowLoggedIn.users;
        const [windowA, windowB] = windows;
        const [userA, userB] = users;
        await (0, send_message_1.sendNewMessage)(windowA, userB.bchatid, `${testMessage}${Date.now()}`);
        await (0, utils_1.clickOnTestIdWithText)(windowB, 'message-request-banner');
        await (0, utils_1.clickOnTestIdWithText)(windowB, 'module-conversation__user__profile-name', userA.userName);
        await (0, utils_1.clickOnTestIdWithText)(windowB, 'decline-message-request');
        await (0, utils_1.clickOnTestIdWithText)(windowB, 'bchat-confirm-ok-button', 'Decline');
        await (0, utils_1.waitForTestIdWithText)(windowB, 'bchat-toast', 'Blocked');
        await (0, utils_1.waitForMatchingText)(windowB, 'No Message Requests Yet!');
    });
});
