"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const beforeEach_1 = require("./setup/beforeEach");
const send_message_1 = require("./send_message");
const new_user_1 = require("./setup/new_user");
const utils_1 = require("./utils");
const testMessage = 'A -> B';
const testReply = 'B -> A';
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
let windows = [];
test_1.test.afterEach(() => (0, beforeEach_1.forceCloseAllWindows)(windows));
(0, test_1.test)('Send message to new contact', async () => {
    const windowLoggedIn = await (0, new_user_1.openAppsAndNewUsers)(2);
    windows = windowLoggedIn.windows;
    const users = windowLoggedIn.users;
    const [windowA, windowB] = windows;
    const [userA, userB] = users;
    await (0, send_message_1.sendNewMessage)(windowA, userB.bchatid, `${testMessage}${Date.now()}`);
    await (0, send_message_1.sendNewMessage)(windowB, userA.bchatid, `${testReply}${Date.now()}`);
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'contact-section');
    await windowA.waitForTimeout(2000);
    await (0, utils_1.waitForTestIdWithText)(windowB, 'module-conversation__user__profile-name', userA.userName);
    await (0, utils_1.clickOnTestIdWithText)(windowA, 'contact-section');
});
