"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const test_1 = require("@playwright/test");
const beforeEach_1 = require("./setup/beforeEach");
const new_user_1 = require("./setup/new_user");
const open_1 = require("./setup/open");
const utils_1 = require("./utils");
let window;
test_1.test.beforeEach(beforeEach_1.cleanUpOtherTest);
test_1.test.afterEach(async () => {
    if (window) {
        await (0, beforeEach_1.forceCloseAllWindows)([window]);
    }
});
const testPassword = '123456';
const newTestPassword = '789101112';
test_1.test.describe('Password checks', () => {
    (0, test_1.test)('Set Password', async () => {
        window = await (0, open_1.openAppAndWait)('1');
        await (0, new_user_1.newUser)(window, 'userA');
        await (0, utils_1.clickOnTestIdWithText)(window, 'settings-section');
        await (0, utils_1.clickOnTestIdWithText)(window, 'privacy-settings-menu-item');
        await (0, utils_1.clickOnTestIdWithText)(window, 'set-password-button');
        await (0, utils_1.typeIntoInput)(window, 'password-input', testPassword);
        await window.keyboard.press('Delete');
        await (0, utils_1.typeIntoInput)(window, 'password-input-confirm', testPassword);
        await window.keyboard.press('Delete');
        await (0, utils_1.clickOnMatchingText)(window, 'OK');
        await (0, utils_1.waitForTestIdWithText)(window, 'bchat-toast', 'Your password has been set. Please keep it safe');
        await (0, utils_1.typeIntoInput)(window, 'password-lock-input', testPassword);
        await (0, utils_1.clickOnMatchingText)(window, 'OK');
        await (0, utils_1.clickOnMatchingText)(window, 'Change Password');
        await (0, utils_1.typeIntoInput)(window, 'password-input', testPassword);
        await window.keyboard.press('Delete');
        await (0, utils_1.typeIntoInput)(window, 'password-input-confirm', newTestPassword);
        await window.keyboard.press('Delete');
        await window.keyboard.press('Tab');
        await (0, utils_1.typeIntoInput)(window, 'password-input-reconfirm', newTestPassword);
        await window.keyboard.press('Delete');
        await window.keyboard.press('Enter');
        await (0, utils_1.clickOnMatchingText)(window, 'OK');
        await (0, utils_1.waitForTestIdWithText)(window, 'bchat-toast', 'Your password has been changed. Please keep it safe.');
    });
    (0, test_1.test)('Wrong password', async () => {
        window = await (0, open_1.openAppAndWait)('1');
        await (0, new_user_1.newUser)(window, 'userA');
        await (0, utils_1.clickOnTestIdWithText)(window, 'settings-section');
        await (0, utils_1.clickOnMatchingText)(window, 'Privacy');
        await (0, utils_1.clickOnMatchingText)(window, 'Set Password');
        await (0, utils_1.typeIntoInput)(window, 'password-input', testPassword);
        await window.keyboard.press('Delete');
        await (0, utils_1.typeIntoInput)(window, 'password-input-confirm', testPassword);
        await window.keyboard.press('Delete');
        await window.keyboard.press('Enter');
        await (0, utils_1.typeIntoInput)(window, 'password-lock-input', testPassword);
        await window.keyboard.press('Delete');
        await (0, utils_1.clickOnMatchingText)(window, 'OK');
        await (0, utils_1.clickOnTestIdWithText)(window, 'message-section');
        await (0, utils_1.clickOnTestIdWithText)(window, 'settings-section');
        await (0, utils_1.typeIntoInput)(window, 'password-lock-input', '0000');
        await window.keyboard.press('Delete');
        await (0, utils_1.clickOnMatchingText)(window, 'OK');
        await (0, utils_1.waitForMatchingText)(window, 'Invalid password');
        await (0, utils_1.clickOnTestIdWithText)(window, 'message-section');
        await (0, utils_1.clickOnTestIdWithText)(window, 'settings-section');
        await (0, utils_1.clickOnMatchingText)(window, 'OK');
        await (0, utils_1.waitForMatchingText)(window, 'Kindly enter your password ');
    });
});
