"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renameGroup = void 0;
const utils_1 = require("./utils");
const renameGroup = async (window, oldGroupName, newGroupName) => {
    await (0, utils_1.clickOnMatchingText)(window, oldGroupName);
    await (0, utils_1.clickOnTestIdWithText)(window, 'conversation-options-avatar');
    await (0, utils_1.clickOnMatchingText)(window, 'Edit group name');
    await (0, utils_1.typeIntoInput)(window, 'group-name-input', newGroupName);
    await window.keyboard.press('Enter');
    await (0, utils_1.waitForTestIdWithText)(window, 'right-panel-group-name', newGroupName);
    await (0, utils_1.clickOnTestIdWithText)(window, 'back-button-conversation-options');
    await (0, utils_1.waitForMatchingText)(window, `Group name is now '${newGroupName}'.`);
};
exports.renameGroup = renameGroup;
