"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.typeIntoInput = exports.getMessageTextContentNow = exports.clickOnTestIdWithText = exports.clickOnMatchingText = exports.waitForMatchingText = exports.waitForReadableMessageWithText = exports.waitForTestIdWithText = void 0;
async function waitForTestIdWithText(window, dataTestId, text) {
    let builtSelector = `css=[data-testid=${dataTestId}]`;
    if (text) {
        builtSelector += `:has-text("${text}")`;
    }
    console.warn('looking for selector', builtSelector);
    const found = await window.waitForSelector(builtSelector, { timeout: 55000 });
    console.warn('found selector', builtSelector);
    return found;
}
exports.waitForTestIdWithText = waitForTestIdWithText;
async function waitForReadableMessageWithText(window, text) {
    return waitForTestIdWithText(window, 'readable-message', text);
}
exports.waitForReadableMessageWithText = waitForReadableMessageWithText;
async function waitForMatchingText(window, text) {
    const builtSelector = `css=:has-text("${text}")`;
    console.warn(`waitForMatchingText: ${text}`);
    await window.waitForSelector(builtSelector, { timeout: 55000 });
    console.warn(`got matchingText: ${text}`);
}
exports.waitForMatchingText = waitForMatchingText;
async function clickOnMatchingText(window, text, rightButton = false) {
    return window.click(`"${text}"`, rightButton ? { button: 'right' } : undefined);
}
exports.clickOnMatchingText = clickOnMatchingText;
async function clickOnTestIdWithText(window, dataTestId, text) {
    if (text) {
        return window.click(`css=[data-testid=${dataTestId}]:has-text("${text}")`);
    }
    const builtSelector = `css=[data-testid=${dataTestId}]`;
    return window.click(builtSelector);
}
exports.clickOnTestIdWithText = clickOnTestIdWithText;
function getMessageTextContentNow() {
    return `Test message timestamp: ${Date.now()}`;
}
exports.getMessageTextContentNow = getMessageTextContentNow;
async function typeIntoInput(window, dataTestId, text) {
    const builtSelector = `css=[data-testid=${dataTestId}]`;
    return window.fill(builtSelector, text);
}
exports.typeIntoInput = typeIntoInput;
