"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const mocha_1 = require("mocha");
const protobuf_1 = require("../../../../protobuf");
const lodash_1 = require("lodash");
const bchat_1 = require("../../../../bchat");
const ReadReceiptMessage_1 = require("../../../../bchat/messages/outgoing/controlMessage/receipt/ReadReceiptMessage");
describe('ReceiptMessage', () => {
    let readMessage;
    let timestamps;
    (0, mocha_1.beforeEach)(() => {
        timestamps = [987654321, 123456789];
        const timestamp = Date.now();
        readMessage = new ReadReceiptMessage_1.ReadReceiptMessage({ timestamp, timestamps });
    });
    it('content of a read receipt is correct', () => {
        const plainText = readMessage.plainTextBuffer();
        const decoded = protobuf_1.SignalService.Content.decode(plainText);
        (0, chai_1.expect)(decoded.receiptMessage).to.have.property('type', 1);
        const decodedTimestamps = (decoded.receiptMessage?.timestamp ?? []).map(lodash_1.toNumber);
        (0, chai_1.expect)(decodedTimestamps).to.deep.equal(timestamps);
    });
    it('correct ttl', () => {
        (0, chai_1.expect)(readMessage.ttl()).to.equal(bchat_1.Constants.TTL_DEFAULT.TTL_MAX);
    });
    it('has an identifier', () => {
        (0, chai_1.expect)(readMessage.identifier).to.not.equal(null, 'identifier cannot be null');
        (0, chai_1.expect)(readMessage.identifier).to.not.equal(undefined, 'identifier cannot be undefined');
    });
});
