"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const protobuf_1 = require("../../../../protobuf");
const long_1 = __importDefault(require("long"));
const lodash_1 = require("lodash");
const bchat_1 = require("../../../../bchat");
const TypingMessage_1 = require("../../../../bchat/messages/outgoing/controlMessage/TypingMessage");
describe('TypingMessage', () => {
    it('has Action.STARTED if isTyping = true', () => {
        const message = new TypingMessage_1.TypingMessage({
            timestamp: Date.now(),
            isTyping: true,
        });
        const plainText = message.plainTextBuffer();
        const decoded = protobuf_1.SignalService.Content.decode(plainText);
        (0, chai_1.expect)(decoded.typingMessage).to.have.property('action', protobuf_1.SignalService.TypingMessage.Action.STARTED);
    });
    it('has Action.STOPPED if isTyping = false', () => {
        const message = new TypingMessage_1.TypingMessage({
            timestamp: Date.now(),
            isTyping: false,
        });
        const plainText = message.plainTextBuffer();
        const decoded = protobuf_1.SignalService.Content.decode(plainText);
        (0, chai_1.expect)(decoded.typingMessage).to.have.property('action', protobuf_1.SignalService.TypingMessage.Action.STOPPED);
    });
    it('has typingTimestamp set if value passed', () => {
        const message = new TypingMessage_1.TypingMessage({
            timestamp: Date.now(),
            isTyping: true,
            typingTimestamp: 111111111,
        });
        const plainText = message.plainTextBuffer();
        const decoded = protobuf_1.SignalService.Content.decode(plainText);
        const decodedtimestamp = (0, lodash_1.toNumber)(decoded.typingMessage?.timestamp);
        (0, chai_1.expect)(decodedtimestamp).to.be.equal(111111111);
    });
    it('has typingTimestamp set with Date.now() if value not passed', () => {
        const message = new TypingMessage_1.TypingMessage({
            timestamp: Date.now(),
            isTyping: true,
        });
        const plainText = message.plainTextBuffer();
        const decoded = protobuf_1.SignalService.Content.decode(plainText);
        let timestamp = decoded.typingMessage?.timestamp;
        if (timestamp instanceof long_1.default) {
            timestamp = timestamp.toNumber();
        }
        (0, chai_1.expect)(timestamp).to.be.approximately(Date.now(), 10);
    });
    it('correct ttl', () => {
        const message = new TypingMessage_1.TypingMessage({
            timestamp: Date.now(),
            isTyping: true,
        });
        (0, chai_1.expect)(message.ttl()).to.equal(bchat_1.Constants.TTL_DEFAULT.TYPING_MESSAGE);
    });
    it('has an identifier', () => {
        const message = new TypingMessage_1.TypingMessage({
            timestamp: Date.now(),
            isTyping: true,
        });
        (0, chai_1.expect)(message.identifier).to.not.equal(null, 'identifier cannot be null');
        (0, chai_1.expect)(message.identifier).to.not.equal(undefined, 'identifier cannot be undefined');
    });
});
