"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importDefault(require("chai"));
const sinon_1 = __importDefault(require("sinon"));
const mocha_1 = require("mocha");
const test_utils_1 = require("../../../test-utils");
const snode_api_1 = require("../../../../bchat/apis/snode_api");
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
const OnionPaths = __importStar(require("../../../../bchat/onions/onionPath"));
const utils_1 = require("../../../test-utils/utils");
const seed_node_api_1 = require("../../../../bchat/apis/seed_node_api");
chai_1.default.use(chai_as_promised_1.default);
chai_1.default.should();
const { expect } = chai_1.default;
const guard1ed = 'e3ec6fcc79e64c2af6a48a9865d4bf4b739ec7708d75f35acc3d478f9161534e';
const guard2ed = 'e3ec6fcc79e64c2af6a48a9865d4bf4b739ec7708d75f35acc3d478f91615349';
const guard3ed = 'e3ec6fcc79e64c2af6a48a9865d4bf4b739ec7708d75f35acc3d478f9161534a';
const fakeSnodePool = [
    ...(0, utils_1.generateFakeSnodes)(12),
    (0, utils_1.generateFakeSnodeWithEdKey)(guard1ed),
    (0, utils_1.generateFakeSnodeWithEdKey)(guard2ed),
    (0, utils_1.generateFakeSnodeWithEdKey)(guard3ed),
    ...(0, utils_1.generateFakeSnodes)(3),
];
const fakeSnodePoolFromSeedNode = fakeSnodePool.map(m => {
    return {
        public_ip: m.ip,
        storage_port: m.port,
        pubkey_x25519: m.pubkey_x25519,
        pubkey_ed25519: m.pubkey_ed25519,
    };
});
(0, mocha_1.describe)('SeedNodeAPI', () => {
    (0, mocha_1.describe)('getSnodeListFromSeednode', () => {
        beforeEach(() => {
            OnionPaths.clearTestOnionPath();
            test_utils_1.TestUtils.stubWindowLog();
            snode_api_1.Onions.resetSnodeFailureCount();
            OnionPaths.resetPathFailureCount();
            snode_api_1.SnodePool.TEST_resetState();
        });
        afterEach(() => {
            sinon_1.default.restore();
        });
        it('if the cached snode pool has less than 12 snodes, trigger a fetch from the seed nodes with retries', async () => {
            const TEST_fetchSnodePoolFromSeedNodeRetryable = sinon_1.default.stub(seed_node_api_1.SeedNodeAPI, 'TEST_fetchSnodePoolFromSeedNodeRetryable')
                .onFirstCall()
                .throws()
                .onSecondCall()
                .resolves(fakeSnodePoolFromSeedNode);
            sinon_1.default.stub(seed_node_api_1.SeedNodeAPI, 'getMinTimeout').returns(20);
            const fetched = await seed_node_api_1.SeedNodeAPI.fetchSnodePoolFromSeedNodeWithRetries(['seednode1']);
            const sortedFetch = fetched.sort((a, b) => (a.pubkey_ed25519 > b.pubkey_ed25519 ? -1 : 1));
            const sortedFakeSnodePool = fakeSnodePool.sort((a, b) => a.pubkey_ed25519 > b.pubkey_ed25519 ? -1 : 1);
            expect(sortedFetch).to.deep.equal(sortedFakeSnodePool);
            expect(TEST_fetchSnodePoolFromSeedNodeRetryable.callCount, 'TEST_fetchSnodePoolFromSeedNodeRetryable called twice as the first one failed').to.be.eq(2);
        });
    });
});
