"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const sinon_1 = __importDefault(require("sinon"));
const hfHandling_1 = require("../../../../bchat/apis/snode_api/hfHandling");
const test_utils_1 = require("../../../test-utils");
describe('hardfork handling', () => {
    describe('getHasSeenHF170', () => {
        afterEach(() => {
            sinon_1.default.restore();
            (0, hfHandling_1.resetHardForkCachedValues)();
        });
        it('fetches from db if undefined, and write to db false if db value is undefined', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves(undefined);
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            const ret = await (0, hfHandling_1.getHasSeenHF170)();
            (0, chai_1.expect)(ret).to.be.eq(false, 'getHasSeenHF170 should return false');
            (0, chai_1.expect)(getItemById.calledOnce).to.be.eq(true, 'getItemById should have been called');
            (0, chai_1.expect)(createItem.calledOnce).to.be.eq(true, 'createItem should have been called');
            (0, chai_1.expect)(createItem.args[0][0]).to.be.deep.eq({ id: 'hasSeenHardfork190', value: false }, 'createItem should have been to set hasSeenHardfork190 to false in the db');
        });
        it('fetches from db if undefined, and does not write to db if db value is not undefined', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves({
                id: 'getHasSeenHF170',
                value: false,
            });
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            const ret = await (0, hfHandling_1.getHasSeenHF170)();
            (0, chai_1.expect)(ret).to.be.eq(false, 'getHasSeenHF170 should return false');
            (0, chai_1.expect)(getItemById.calledOnce).to.be.eq(true, 'getItemById should have been called');
            (0, chai_1.expect)(createItem.notCalled).to.be.eq(true, 'createItem should not have been called');
        });
        it('fetches from db if undefined, and does not write to db if db value is not undefined - 2', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves({
                id: 'getHasSeenHF170',
                value: true,
            });
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            const ret = await (0, hfHandling_1.getHasSeenHF170)();
            (0, chai_1.expect)(ret).to.be.eq(true, 'getHasSeenHF170 should return false');
            (0, chai_1.expect)(getItemById.calledOnce).to.be.eq(true, 'getItemById should have been called');
            (0, chai_1.expect)(createItem.notCalled).to.be.eq(true, 'createItem should not have been called');
        });
        it('fetches from db only the value is not cached already', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves({
                id: 'getHasSeenHF170',
                value: true,
            });
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            const ret = await (0, hfHandling_1.getHasSeenHF170)();
            const ret2 = await (0, hfHandling_1.getHasSeenHF170)();
            (0, chai_1.expect)(ret).to.be.eq(true, 'getHasSeenHF170 should return false');
            (0, chai_1.expect)(ret2).to.be.eq(true, 'getHasSeenHF170 should return false - 2');
            (0, chai_1.expect)(getItemById.calledOnce).to.be.eq(true, 'getItemById should have been called');
            (0, chai_1.expect)(createItem.notCalled).to.be.eq(true, 'createItem should not have been called');
        });
    });
    describe('getHasSeenHF180', () => {
        afterEach(() => {
            sinon_1.default.restore();
            (0, hfHandling_1.resetHardForkCachedValues)();
        });
        it('fetches from db if undefined, and write to db false if db value is undefined', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves(undefined);
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            const ret = await (0, hfHandling_1.getHasSeenHF180)();
            (0, chai_1.expect)(ret).to.be.eq(false, 'getHasSeenHF180 should return false');
            (0, chai_1.expect)(getItemById.calledOnce).to.be.eq(true, 'getItemById should have been called');
            (0, chai_1.expect)(createItem.calledOnce).to.be.eq(true, 'createItem should have been called');
            (0, chai_1.expect)(createItem.args[0][0]).to.be.deep.eq({ id: 'hasSeenHardfork191', value: false }, 'createItem should have been to set hasSeenHardfork191 to false in the db');
        });
        it('fetches from db if undefined, and does not write to db if db value is not undefined', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves({
                id: 'getHasSeenHF180',
                value: false,
            });
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            const ret = await (0, hfHandling_1.getHasSeenHF180)();
            (0, chai_1.expect)(ret).to.be.eq(false, 'getHasSeenHF180 should return false');
            (0, chai_1.expect)(getItemById.calledOnce).to.be.eq(true, 'getItemById should have been called');
            (0, chai_1.expect)(createItem.notCalled).to.be.eq(true, 'createItem should not have been called');
        });
        it('fetches from db if undefined, and does not write to db if db value is not undefined - 2', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves({
                id: 'getHasSeenHF180',
                value: true,
            });
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            const ret = await (0, hfHandling_1.getHasSeenHF180)();
            (0, chai_1.expect)(ret).to.be.eq(true, 'getHasSeenHF180 should return false');
            (0, chai_1.expect)(getItemById.calledOnce).to.be.eq(true, 'getItemById should have been called');
            (0, chai_1.expect)(createItem.notCalled).to.be.eq(true, 'createItem should not have been called');
        });
        it('fetches from db only the value is not cached already', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves({
                id: 'getHasSeenHF180',
                value: true,
            });
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            const ret = await (0, hfHandling_1.getHasSeenHF180)();
            const ret2 = await (0, hfHandling_1.getHasSeenHF180)();
            (0, chai_1.expect)(ret).to.be.eq(true, 'getHasSeenHF180 should return false');
            (0, chai_1.expect)(ret2).to.be.eq(true, 'getHasSeenHF180 should return false - 2');
            (0, chai_1.expect)(getItemById.calledOnce).to.be.eq(true, 'getItemById should have been called');
            (0, chai_1.expect)(createItem.notCalled).to.be.eq(true, 'createItem should not have been called');
        });
    });
    describe('handleHardforkResult', () => {
        afterEach(() => {
            sinon_1.default.restore();
            (0, hfHandling_1.resetHardForkCachedValues)();
        });
        it('does not fail if null is given as json', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves(undefined);
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            await (0, hfHandling_1.handleHardforkResult)(null);
            (0, chai_1.expect)(getItemById.calledTwice).to.be.eq(true, 'getItemById should have been calledTwice');
            (0, chai_1.expect)(createItem.calledTwice).to.be.eq(true, 'createItem should have been calledTwice');
            (0, chai_1.expect)(createItem.args[0][0]).to.be.deep.eq({ id: 'hasSeenHardfork190', value: false }, 'createItem should have been to set hasSeenHardfork190 to false in the db');
            (0, chai_1.expect)(createItem.args[1][0]).to.be.deep.eq({ id: 'hasSeenHardfork191', value: false }, 'createItem should have been to set hasSeenHardfork191 to false in the db');
        });
        it('does not fail on empty json object', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves(undefined);
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            await (0, hfHandling_1.handleHardforkResult)({});
            (0, chai_1.expect)(getItemById.calledTwice).to.be.eq(true, 'getItemById should have been calledTwice');
            (0, chai_1.expect)(createItem.calledTwice).to.be.eq(true, 'createItem should have been calledTwice');
            (0, chai_1.expect)(createItem.args[0][0]).to.be.deep.eq({ id: 'hasSeenHardfork190', value: false }, 'createItem should have been to set hasSeenHardfork190 to false in the db');
            (0, chai_1.expect)(createItem.args[1][0]).to.be.deep.eq({ id: 'hasSeenHardfork191', value: false }, 'createItem should have been to set hasSeenHardfork191 to false in the db');
        });
        it('does not fail with invalid array length of 3', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves(undefined);
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            await (0, hfHandling_1.handleHardforkResult)({ hf: [1, 2, 3] });
            (0, chai_1.expect)(getItemById.calledTwice).to.be.eq(true, 'getItemById should have been calledTwice');
            (0, chai_1.expect)(createItem.calledTwice).to.be.eq(true, 'createItem should have been calledTwice');
            (0, chai_1.expect)(createItem.args[0][0]).to.be.deep.eq({ id: 'hasSeenHardfork190', value: false }, 'createItem should have been to set hasSeenHardfork190 to false in the db');
            (0, chai_1.expect)(createItem.args[1][0]).to.be.deep.eq({ id: 'hasSeenHardfork191', value: false }, 'createItem should have been to set hasSeenHardfork191 to false in the db');
        });
        it('does not fail with invalid array length of 3', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves(undefined);
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            await (0, hfHandling_1.handleHardforkResult)({ hf: [1, 2, 3] });
            (0, chai_1.expect)(getItemById.calledTwice).to.be.eq(true, 'getItemById should have been calledTwice');
            (0, chai_1.expect)(createItem.calledTwice).to.be.eq(true, 'createItem should have been calledTwice');
            (0, chai_1.expect)(createItem.args[0][0]).to.be.deep.eq({ id: 'hasSeenHardfork190', value: false }, 'createItem should have been to set hasSeenHardfork190 to false in the db');
            (0, chai_1.expect)(createItem.args[1][0]).to.be.deep.eq({ id: 'hasSeenHardfork191', value: false }, 'createItem should have been to set hasSeenHardfork191 to false in the db');
        });
        it('does not fail with invalid array length of but not numbers', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves(undefined);
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            await (0, hfHandling_1.handleHardforkResult)({ hf: ['1', 2] });
            (0, chai_1.expect)(getItemById.calledTwice).to.be.eq(true, 'getItemById should have been calledTwice');
            (0, chai_1.expect)(createItem.calledTwice).to.be.eq(true, 'createItem should have been calledTwice');
            (0, chai_1.expect)(createItem.args[0][0]).to.be.deep.eq({ id: 'hasSeenHardfork190', value: false }, 'createItem should have been to set hasSeenHardfork190 to false in the db');
            (0, chai_1.expect)(createItem.args[1][0]).to.be.deep.eq({ id: 'hasSeenHardfork191', value: false }, 'createItem should have been to set hasSeenHardfork191 to false in the db');
        });
        it('does not fail with invalid array length of 1 ', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves(undefined);
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            await (0, hfHandling_1.handleHardforkResult)({ hf: [1] });
            (0, chai_1.expect)(getItemById.calledTwice).to.be.eq(true, 'getItemById should have been calledTwice');
            (0, chai_1.expect)(createItem.calledTwice).to.be.eq(true, 'createItem should have been calledTwice');
            (0, chai_1.expect)(createItem.args[0][0]).to.be.deep.eq({ id: 'hasSeenHardfork190', value: false }, 'createItem should have been to set hasSeenHardfork190 to false in the db');
            (0, chai_1.expect)(createItem.args[1][0]).to.be.deep.eq({ id: 'hasSeenHardfork191', value: false }, 'createItem should have been to set hasSeenHardfork191 to false in the db');
        });
        it('does not write new data if hf major is <= 18 ', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves(undefined);
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            await (0, hfHandling_1.handleHardforkResult)({ hf: [18, 9] });
            (0, chai_1.expect)(getItemById.calledTwice).to.be.eq(true, 'getItemById should have been calledTwice');
            (0, chai_1.expect)(createItem.calledTwice).to.be.eq(true, 'createItem should have been calledTwice');
            (0, chai_1.expect)(createItem.args[0][0]).to.be.deep.eq({ id: 'hasSeenHardfork190', value: false }, 'createItem should have been to set hasSeenHardfork190 to false in the db');
            (0, chai_1.expect)(createItem.args[1][0]).to.be.deep.eq({ id: 'hasSeenHardfork191', value: false }, 'createItem should have been to set hasSeenHardfork191 to false in the db');
        });
        it('does write new data if hf major is === 19 and minor === 0  ', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves(undefined);
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            await (0, hfHandling_1.handleHardforkResult)({ hf: [19, 0] });
            (0, chai_1.expect)(getItemById.calledTwice).to.be.eq(true, 'getItemById should have been calledTwice');
            (0, chai_1.expect)(createItem.calledThrice).to.be.eq(true, 'createItem should have been calledThrice');
            (0, chai_1.expect)(createItem.args[0][0]).to.be.deep.eq({ id: 'hasSeenHardfork190', value: false }, 'createItem should have been to set hasSeenHardfork190 to false in the db');
            (0, chai_1.expect)(createItem.args[1][0]).to.be.deep.eq({ id: 'hasSeenHardfork191', value: false }, 'createItem should have been to set hasSeenHardfork191 to false in the db');
            (0, chai_1.expect)(createItem.args[2][0]).to.be.deep.eq({ id: 'hasSeenHardfork190', value: true }, 'createItem should have been to set hasSeenHardfork191 to true in the db');
            getItemById.resetHistory();
            createItem.resetHistory();
            (0, chai_1.expect)(await (0, hfHandling_1.getHasSeenHF170)()).to.be.eq(true, 'getHasSeenHF170 should have been true');
            (0, chai_1.expect)(getItemById.notCalled).to.be.eq(true, 'getItemById should not have been called more');
            (0, chai_1.expect)(createItem.notCalled).to.be.eq(true, 'createItem should not have been called more');
        });
        it('does write new data if hf major is === 19 and minor === 1 ', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves(undefined);
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            await (0, hfHandling_1.handleHardforkResult)({ hf: [19, 1] });
            (0, chai_1.expect)(getItemById.calledTwice).to.be.eq(true, 'getItemById should have been calledTwice');
            (0, chai_1.expect)(createItem.callCount).to.be.eq(4, 'createItem should have been 4');
            (0, chai_1.expect)(createItem.args[0][0]).to.be.deep.eq({ id: 'hasSeenHardfork190', value: false }, 'createItem should have been to set hasSeenHardfork190 to false in the db');
            (0, chai_1.expect)(createItem.args[1][0]).to.be.deep.eq({ id: 'hasSeenHardfork191', value: false }, 'createItem should have been to set hasSeenHardfork191 to false in the db');
            (0, chai_1.expect)(createItem.args[2][0]).to.be.deep.eq({ id: 'hasSeenHardfork190', value: true }, 'createItem should have been to set hasSeenHardfork190 to true in the db');
            (0, chai_1.expect)(createItem.args[3][0]).to.be.deep.eq({ id: 'hasSeenHardfork191', value: true }, 'createItem should have been to set hasSeenHardfork191 to true in the db');
            getItemById.resetHistory();
            createItem.resetHistory();
            (0, chai_1.expect)(await (0, hfHandling_1.getHasSeenHF170)()).to.be.eq(true, 'getHasSeenHF170 should have been true');
            (0, chai_1.expect)(await (0, hfHandling_1.getHasSeenHF180)()).to.be.eq(true, 'getHasSeenHF180 should have been true');
            (0, chai_1.expect)(getItemById.notCalled).to.be.eq(true, 'getItemById should not have been called more');
            (0, chai_1.expect)(createItem.notCalled).to.be.eq(true, 'createItem should not have been called more');
        });
        it('does not write new data if hf major is === 19 and minor === 1 but it is already known we have seen both forks ', async () => {
            const getItemById = test_utils_1.TestUtils.stubDataItem('getItemById').resolves({ id: '', value: true });
            const createItem = test_utils_1.TestUtils.stubDataItem('createOrUpdateItem').resolves();
            await (0, hfHandling_1.handleHardforkResult)({ hf: [19, 1] });
            (0, chai_1.expect)(getItemById.calledTwice).to.be.eq(true, 'getItemById should have been calledTwice');
            (0, chai_1.expect)(createItem.callCount).to.be.eq(0, 'createItem should have been 0');
            getItemById.resetHistory();
            createItem.resetHistory();
            (0, chai_1.expect)(await (0, hfHandling_1.getHasSeenHF170)()).to.be.eq(true, 'getHasSeenHF170 should have been true');
            (0, chai_1.expect)(await (0, hfHandling_1.getHasSeenHF180)()).to.be.eq(true, 'getHasSeenHF180 should have been true');
            (0, chai_1.expect)(getItemById.notCalled).to.be.eq(true, 'getItemById should not have been called more');
            (0, chai_1.expect)(createItem.notCalled).to.be.eq(true, 'createItem should not have been called more');
        });
    });
});
