"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importStar(require("chai"));
const sinon_1 = __importStar(require("sinon"));
const reactions_1 = require("../../../../util/reactions");
const Data = __importStar(require("../../../../../ts/data/data"));
const Storage = __importStar(require("../../../../util/storage"));
const utils_1 = require("../../../test-utils/utils");
const constants_1 = require("../../../../bchat/constants");
const lodash_1 = require("lodash");
const utils_2 = require("../../../../bchat/utils");
const message_1 = require("../../../../models/message");
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
chai_1.default.use(chai_as_promised_1.default);
describe('ReactionMessage', () => {
    (0, utils_1.stubWindowLog)();
    let clock;
    const ourNumber = '0123456789abcdef';
    const originalMessage = (0, utils_1.generateFakeIncomingPrivateMessage)();
    originalMessage.set('sent_at', Date.now());
    beforeEach(() => {
        sinon_1.default.stub(originalMessage, 'getConversation').returns({
            sendReaction: lodash_1.noop,
        });
        sinon_1.default.stub(Data, 'getMessageById').resolves(originalMessage);
        sinon_1.default.stub(Storage, 'getRecentReactions').returns(constants_1.DEFAULT_RECENT_REACTS);
        sinon_1.default.stub(Storage, 'saveRecentReations').resolves();
        sinon_1.default.stub(utils_2.UserUtils, 'getOurPubKeyStrFromCache').returns(ourNumber);
        sinon_1.default.stub(Data, 'getMessagesBySentAt').resolves(new message_1.MessageCollection([originalMessage]));
        sinon_1.default.stub(originalMessage, 'commit').resolves();
    });
    it('can react to a message', async () => {
        const reaction = await (0, reactions_1.sendMessageReaction)(originalMessage.get('id'), '😄');
        (0, chai_1.expect)(reaction?.id, 'id should match the original message timestamp').to.be.equal(Number(originalMessage.get('sent_at')));
        (0, chai_1.expect)(reaction?.author, 'author should match the original message author').to.be.equal(originalMessage.get('source'));
        (0, chai_1.expect)(reaction?.emoji, 'emoji should be 😄').to.be.equal('😄');
        (0, chai_1.expect)(reaction?.action, 'action should be 0').to.be.equal(0);
        const updatedMessage = await (0, reactions_1.handleMessageReaction)(reaction, ourNumber, false, originalMessage.get('id'));
        (0, chai_1.expect)(updatedMessage?.get('reacts'), 'original message should have reacts').to.not.be
            .undefined;
        (0, chai_1.expect)(updatedMessage?.get('reacts')['😄'], 'reacts should have 😄 key').to.not.be.undefined;
        (0, chai_1.expect)(Object.keys(updatedMessage.get('reacts')['😄'].senders)[0], 'sender pubkey should match').to.be.equal(ourNumber);
        (0, chai_1.expect)(updatedMessage.get('reacts')['😄'].count, 'count should be 1').to.be.equal(1);
    });
    it('can remove a reaction from a message', async () => {
        const reaction = await (0, reactions_1.sendMessageReaction)(originalMessage.get('id'), '😄');
        (0, chai_1.expect)(reaction?.id, 'id should match the original message timestamp').to.be.equal(Number(originalMessage.get('sent_at')));
        (0, chai_1.expect)(reaction?.author, 'author should match the original message author').to.be.equal(originalMessage.get('source'));
        (0, chai_1.expect)(reaction?.emoji, 'emoji should be 😄').to.be.equal('😄');
        (0, chai_1.expect)(reaction?.action, 'action should be 1').to.be.equal(1);
        const updatedMessage = await (0, reactions_1.handleMessageReaction)(reaction, ourNumber, false, originalMessage.get('id'));
        (0, chai_1.expect)(updatedMessage?.get('reacts'), 'original message reacts should be undefined').to.be
            .undefined;
    });
    it('reactions are rate limited to 20 reactions per minute', async () => {
        for (let i = 0; i < 18; i++) {
            await (0, reactions_1.sendMessageReaction)(originalMessage.get('id'), '👍');
        }
        let reaction = await (0, reactions_1.sendMessageReaction)(originalMessage.get('id'), '👎');
        (0, chai_1.expect)(reaction, 'no reaction should be returned since we are over the rate limit').to.be
            .undefined;
        clock = (0, sinon_1.useFakeTimers)(Date.now());
        clock.tick(1 * 60 * 1000);
        reaction = await (0, reactions_1.sendMessageReaction)(originalMessage.get('id'), '👋');
        (0, chai_1.expect)(reaction?.id, 'id should match the original message timestamp').to.be.equal(Number(originalMessage.get('sent_at')));
        (0, chai_1.expect)(reaction?.author, 'author should match the original message author').to.be.equal(originalMessage.get('source'));
        (0, chai_1.expect)(reaction?.emoji, 'emoji should be 👋').to.be.equal('👋');
        (0, chai_1.expect)(reaction?.action, 'action should be 0').to.be.equal(0);
        clock.restore();
    });
    it('a moderator can batch clear a reaction in an open group', () => {
    });
    afterEach(() => {
        sinon_1.default.restore();
    });
});
