"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importDefault(require("chai"));
const mocha_1 = require("mocha");
const sinon_1 = __importDefault(require("sinon"));
const SogsFilterDuplicate_1 = require("../../../../../bchat/apis/open_group_api/opengroupV2/SogsFilterDuplicate");
const test_utils_1 = require("../../../../test-utils");
const { expect } = chai_1.default;
(0, mocha_1.describe)('filterDuplicatesFromDbAndIncoming', () => {
    (0, mocha_1.describe)('filters already duplicated message in the same incoming batch', () => {
        beforeEach(() => {
            test_utils_1.TestUtils.stubData('filterAlreadyFetchedOpengroupMessage').returnsArg(0);
            test_utils_1.TestUtils.stubWindowLog();
        });
        afterEach(() => {
            sinon_1.default.restore();
        });
        it('no duplicates', async () => {
            const msg1 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const msg2 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const msg3 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const filtered = await (0, SogsFilterDuplicate_1.filterDuplicatesFromDbAndIncoming)([msg1, msg2, msg3]);
            expect(filtered.length).to.be.eq(3);
            expect(filtered[0]).to.be.deep.eq(msg1);
            expect(filtered[1]).to.be.deep.eq(msg2);
            expect(filtered[2]).to.be.deep.eq(msg3);
        });
        it('two duplicate sender but not the same timestamp', async () => {
            const msg1 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const msg2 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            msg2.sender = msg1.sender;
            msg2.sentTimestamp = Date.now() + 2;
            const msg3 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const filtered = await (0, SogsFilterDuplicate_1.filterDuplicatesFromDbAndIncoming)([msg1, msg2, msg3]);
            expect(filtered.length).to.be.eq(3);
            expect(filtered[0]).to.be.deep.eq(msg1);
            expect(filtered[1]).to.be.deep.eq(msg2);
            expect(filtered[2]).to.be.deep.eq(msg3);
        });
        it('two duplicate timestamp but not the same sender', async () => {
            const msg1 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const msg2 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            msg2.sentTimestamp = msg1.sentTimestamp;
            const msg3 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const filtered = await (0, SogsFilterDuplicate_1.filterDuplicatesFromDbAndIncoming)([msg1, msg2, msg3]);
            expect(filtered.length).to.be.eq(3);
            expect(filtered[0]).to.be.deep.eq(msg1);
            expect(filtered[1]).to.be.deep.eq(msg2);
            expect(filtered[2]).to.be.deep.eq(msg3);
        });
        it('two duplicate timestamp but not the same sender', async () => {
            const msg1 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const msg2 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            msg2.sentTimestamp = msg1.sentTimestamp;
            const msg3 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const filtered = await (0, SogsFilterDuplicate_1.filterDuplicatesFromDbAndIncoming)([msg1, msg2, msg3]);
            expect(filtered.length).to.be.eq(3);
            expect(filtered[0]).to.be.deep.eq(msg1);
            expect(filtered[1]).to.be.deep.eq(msg2);
            expect(filtered[2]).to.be.deep.eq(msg3);
        });
        it('two duplicates in the same poll ', async () => {
            const msg1 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const msg2 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            msg2.sentTimestamp = msg1.sentTimestamp;
            msg2.sender = msg1.sender;
            const msg3 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const filtered = await (0, SogsFilterDuplicate_1.filterDuplicatesFromDbAndIncoming)([msg1, msg2, msg3]);
            expect(filtered.length).to.be.eq(2);
            expect(filtered[0]).to.be.deep.eq(msg1);
            expect(filtered[1]).to.be.deep.eq(msg3);
        });
        it('three duplicates in the same poll', async () => {
            const msg1 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const msg2 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const msg3 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            msg2.sentTimestamp = msg1.sentTimestamp;
            msg2.sender = msg1.sender;
            msg3.sentTimestamp = msg1.sentTimestamp;
            msg3.sender = msg1.sender;
            const filtered = await (0, SogsFilterDuplicate_1.filterDuplicatesFromDbAndIncoming)([msg1, msg2, msg3]);
            expect(filtered.length).to.be.eq(1);
            expect(filtered[0]).to.be.deep.eq(msg1);
        });
        it('three duplicates in the same poll', async () => {
            const msg1 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const msg2 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            const msg3 = test_utils_1.TestUtils.generateOpenGroupMessageV2();
            msg2.sentTimestamp = msg1.sentTimestamp;
            msg2.sender = msg1.sender;
            msg3.sentTimestamp = msg1.sentTimestamp;
            msg3.sender = msg1.sender;
            const filtered = await (0, SogsFilterDuplicate_1.filterDuplicatesFromDbAndIncoming)([msg1, msg2, msg3]);
            expect(filtered.length).to.be.eq(1);
            expect(filtered[0]).to.be.deep.eq(msg1);
        });
    });
    (0, mocha_1.describe)('filters duplicated message from database', () => {
        it.skip('in memory database', () => { });
    });
});
