"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importDefault(require("chai"));
const sinon_1 = __importDefault(require("sinon"));
const mocha_1 = require("mocha");
const crypto_1 = require("crypto");
const Data = __importStar(require("../../../../data/data"));
const utils_1 = require("../../../../bchat/utils");
const test_utils_1 = require("../../../test-utils");
const MessageQueue_1 = require("../../../../bchat/sending/MessageQueue");
const types_1 = require("../../../../bchat/types");
const sending_1 = require("../../../../bchat/sending");
const stubs_1 = require("../../../test-utils/stubs");
const ClosedGroupMessage_1 = require("../../../../bchat/messages/outgoing/controlMessage/group/ClosedGroupMessage");
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
const MessageSentHandler_1 = require("../../../../bchat/sending/MessageSentHandler");
chai_1.default.use(chai_as_promised_1.default);
chai_1.default.should();
const { expect } = chai_1.default;
(0, mocha_1.describe)('MessageQueue', () => {
    const ourDevice = test_utils_1.TestUtils.generateFakePubKey();
    const ourNumber = ourDevice.key;
    let pendingMessageCache;
    let messageSentHandlerFailedStub;
    let messageSentHandlerSuccessStub;
    let messageSentPublicHandlerSuccessStub;
    let messageQueueStub;
    let sendStub;
    beforeEach(() => {
        sinon_1.default.stub(utils_1.UserUtils, 'getOurPubKeyStrFromCache').returns(ourNumber);
        sendStub = sinon_1.default.stub(sending_1.MessageSender, 'send');
        messageSentHandlerFailedStub = sinon_1.default.stub(MessageSentHandler_1.MessageSentHandler, 'handleMessageSentFailure').resolves();
        messageSentHandlerSuccessStub = sinon_1.default.stub(MessageSentHandler_1.MessageSentHandler, 'handleMessageSentSuccess').resolves();
        messageSentPublicHandlerSuccessStub = sinon_1.default.stub(MessageSentHandler_1.MessageSentHandler, 'handlePublicMessageSentSuccess').resolves();
        pendingMessageCache = new stubs_1.PendingMessageCacheStub();
        messageQueueStub = new MessageQueue_1.MessageQueue(pendingMessageCache);
        test_utils_1.TestUtils.stubWindowLog();
    });
    afterEach(() => {
        sinon_1.default.restore();
    });
    (0, mocha_1.describe)('processPending', () => {
        it('will send messages', done => {
            const device = test_utils_1.TestUtils.generateFakePubKey();
            const waitForMessageSentEvent = new Promise(resolve => {
                resolve(true);
                done();
            });
            void pendingMessageCache
                .add(device, test_utils_1.TestUtils.generateVisibleMessage(), waitForMessageSentEvent)
                .then(async () => {
                return messageQueueStub.processPending(device);
            })
                .then(() => {
                expect(waitForMessageSentEvent).to.be.fulfilled;
            });
        });
        it('should remove message from cache', async () => {
            const events = ['sendSuccess', 'sendFail'];
            for (const event of events) {
                if (event === 'sendSuccess') {
                    sendStub.resolves();
                }
                else {
                    sendStub.throws(new Error('fail'));
                }
                const device = test_utils_1.TestUtils.generateFakePubKey();
                await pendingMessageCache.add(device, test_utils_1.TestUtils.generateVisibleMessage());
                const initialMessages = await pendingMessageCache.getForDevice(device);
                expect(initialMessages).to.have.length(1);
                await messageQueueStub.processPending(device);
                const promise = utils_1.PromiseUtils.waitUntil(async () => {
                    const messages = await pendingMessageCache.getForDevice(device);
                    return messages.length === 0;
                }, 100);
                return promise.should.be.fulfilled;
            }
        }).timeout(15000);
        (0, mocha_1.describe)('events', () => {
            it('should send a success event if message was sent', done => {
                sinon_1.default.stub(Data, 'getMessageById').resolves();
                const message = test_utils_1.TestUtils.generateVisibleMessage();
                sendStub.resolves({ effectiveTimestamp: Date.now(), wrappedEnvelope: (0, crypto_1.randomBytes)(10) });
                const device = test_utils_1.TestUtils.generateFakePubKey();
                sinon_1.default.stub(sending_1.MessageSender, 'getMinRetryTimeout').returns(10);
                const waitForMessageSentEvent = async () => new Promise(resolve => {
                    resolve();
                    try {
                        expect(messageSentHandlerSuccessStub.callCount).to.be.equal(1);
                        expect(messageSentHandlerSuccessStub.lastCall.args[0].identifier).to.be.equal(message.identifier);
                        done();
                    }
                    catch (e) {
                        done(e);
                    }
                });
                void pendingMessageCache
                    .add(device, message, waitForMessageSentEvent)
                    .then(() => messageQueueStub.processPending(device));
            });
            it('should send a fail event if something went wrong while sending', async () => {
                sendStub.throws(new Error('failure'));
                const device = test_utils_1.TestUtils.generateFakePubKey();
                const message = test_utils_1.TestUtils.generateVisibleMessage();
                void pendingMessageCache
                    .add(device, message)
                    .then(() => messageQueueStub.processPending(device));
                return utils_1.PromiseUtils.poll(done => {
                    if (messageSentHandlerFailedStub.callCount === 1) {
                        try {
                            expect(messageSentHandlerFailedStub.callCount).to.be.equal(1);
                            expect(messageSentHandlerFailedStub.lastCall.args[0].identifier).to.be.equal(message.identifier);
                            expect(messageSentHandlerFailedStub.lastCall.args[1].message).to.equal('failure');
                            done();
                        }
                        catch (e) {
                            done(e);
                        }
                    }
                });
            });
        });
    });
    (0, mocha_1.describe)('sendToPubKey', () => {
        it('should send the message to the device', async () => {
            const device = test_utils_1.TestUtils.generateFakePubKey();
            const stub = sinon_1.default.stub(messageQueueStub, 'process').resolves();
            const message = test_utils_1.TestUtils.generateVisibleMessage();
            await messageQueueStub.sendToPubKey(device, message);
            const args = stub.lastCall.args;
            expect(args[0]).to.be.equal(device);
            expect(args[1]).to.equal(message);
        });
    });
    (0, mocha_1.describe)('sendToGroup', () => {
        it('should throw an error if invalid non-group message was passed', async () => {
            const chatMessage = test_utils_1.TestUtils.generateVisibleMessage();
            return expect(messageQueueStub.sendToGroup(chatMessage)).to.be.rejectedWith('Invalid group message passed in sendToGroup.');
        });
        (0, mocha_1.describe)('closed groups', () => {
            it('can send to closed group', async () => {
                const members = test_utils_1.TestUtils.generateFakePubKeys(4).map(p => new types_1.PubKey(p.key));
                sinon_1.default.stub(utils_1.GroupUtils, 'getGroupMembers').returns(members);
                const send = sinon_1.default.stub(messageQueueStub, 'sendToPubKey').resolves();
                const message = test_utils_1.TestUtils.generateClosedGroupMessage();
                await messageQueueStub.sendToGroup(message);
                expect(send.callCount).to.equal(1);
                const arg = send.getCall(0).args;
                expect(arg[1] instanceof ClosedGroupMessage_1.ClosedGroupMessage).to.equal(true, 'message sent to group member was not a ClosedGroupMessage');
            });
            (0, mocha_1.describe)('Social groupsv2', () => {
                let sendToOpenGroupV2Stub;
                beforeEach(() => {
                    sendToOpenGroupV2Stub = sinon_1.default.stub(sending_1.MessageSender, 'sendToOpenGroupV2').resolves(test_utils_1.TestUtils.generateOpenGroupMessageV2());
                });
                it('can send to Social group', async () => {
                    const message = test_utils_1.TestUtils.generateOpenGroupVisibleMessage();
                    const roomInfos = test_utils_1.TestUtils.generateOpenGroupV2RoomInfos();
                    await messageQueueStub.sendToOpenGroupV2(message, roomInfos);
                    expect(sendToOpenGroupV2Stub.callCount).to.equal(1);
                });
                it('should emit a success event when send was successful', async () => {
                    sendToOpenGroupV2Stub.resolves({
                        serverId: 5125,
                        sentTimestamp: 5126,
                    });
                    const message = test_utils_1.TestUtils.generateOpenGroupVisibleMessage();
                    const roomInfos = test_utils_1.TestUtils.generateOpenGroupV2RoomInfos();
                    await messageQueueStub.sendToOpenGroupV2(message, roomInfos);
                    expect(messageSentPublicHandlerSuccessStub.callCount).to.equal(1);
                    expect(messageSentPublicHandlerSuccessStub.lastCall.args[0].identifier).to.equal(message.identifier);
                    expect(messageSentPublicHandlerSuccessStub.lastCall.args[1].serverId).to.equal(5125);
                    expect(messageSentPublicHandlerSuccessStub.lastCall.args[1].serverTimestamp).to.equal(5126);
                });
                it('should emit a fail event if something went wrong', async () => {
                    sendToOpenGroupV2Stub.resolves({ serverId: -1, serverTimestamp: -1 });
                    const message = test_utils_1.TestUtils.generateOpenGroupVisibleMessage();
                    const roomInfos = test_utils_1.TestUtils.generateOpenGroupV2RoomInfos();
                    await messageQueueStub.sendToOpenGroupV2(message, roomInfos);
                    expect(messageSentHandlerFailedStub.callCount).to.equal(1);
                    expect(messageSentHandlerFailedStub.lastCall.args[0].identifier).to.equal(message.identifier);
                });
            });
        });
    });
});
