"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importDefault(require("chai"));
const sinon_1 = __importStar(require("sinon")), sinon = sinon_1;
const mocha_1 = require("mocha");
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
const test_utils_1 = require("../../../test-utils");
const utils_1 = require("../../../../bchat/utils");
const conversations_1 = require("../../../../bchat/conversations");
const Data = __importStar(require("../../../../data/data"));
const DataItem = __importStar(require("../../../../data/channelsItem"));
const snode_api_1 = require("../../../../bchat/apis/snode_api");
const constants_1 = require("../../../../bchat/constants");
const conversation_1 = require("../../../../models/conversation");
const types_1 = require("../../../../bchat/types");
const utils_2 = require("../../../test-utils/utils");
const hfHandling_1 = require("../../../../bchat/apis/snode_api/hfHandling");
const Promise_1 = require("../../../../bchat/utils/Promise");
chai_1.default.use(chai_as_promised_1.default);
chai_1.default.should();
const { expect } = chai_1.default;
(0, mocha_1.describe)('SwarmPolling', () => {
    const ourPubkey = test_utils_1.TestUtils.generateFakePubKey();
    const ourNumber = ourPubkey.key;
    let pollOnceForKeySpy;
    let swarmPolling;
    let getItemByIdStub;
    let clock;
    beforeEach(async () => {
        sinon_1.default.stub(utils_1.UserUtils, 'getOurPubKeyStrFromCache').returns(ourNumber);
        sinon_1.default.stub(Data, 'getAllConversations').resolves(new conversation_1.ConversationCollection());
        getItemByIdStub = test_utils_1.TestUtils.stubDataItem('getItemById');
        sinon_1.default.stub(Data, 'saveConversation').resolves();
        sinon_1.default.stub(Data, 'getSwarmNodesForPubkey').resolves();
        sinon_1.default.stub(Data, 'getLastHashBySnode').resolves();
        sinon_1.default.stub(snode_api_1.SnodePool, 'getSwarmFor').resolves((0, utils_2.generateFakeSnodes)(5));
        sinon_1.default.stub(snode_api_1.SNodeAPI, 'retrieveNextMessages').resolves([]);
        test_utils_1.TestUtils.stubWindow('inboxStore', undefined);
        test_utils_1.TestUtils.stubWindow('getGlobalOnlineStatus', () => true);
        test_utils_1.TestUtils.stubWindowLog();
        const convoController = (0, conversations_1.getConversationController)();
        await convoController.load();
        (0, conversations_1.getConversationController)().getOrCreate(ourPubkey.key, conversation_1.ConversationTypeEnum.PRIVATE);
        swarmPolling = (0, snode_api_1.getSwarmPollingInstance)();
        swarmPolling.resetSwarmPolling();
        pollOnceForKeySpy = sinon_1.default.spy(swarmPolling, 'pollOnceForKey');
        clock = sinon.useFakeTimers(Date.now());
    });
    afterEach(() => {
        sinon_1.default.restore();
        (0, conversations_1.getConversationController)().reset();
        clock.restore();
        (0, hfHandling_1.resetHardForkCachedValues)();
    });
    (0, mocha_1.describe)('getPollingTimeout', () => {
        it('returns INACTIVE for non existing convo', () => {
            const fakeConvo = test_utils_1.TestUtils.generateFakePubKey();
            expect(swarmPolling.getPollingTimeout(fakeConvo)).to.eq(constants_1.SWARM_POLLING_TIMEOUT.INACTIVE);
        });
        it('returns ACTIVE for convo with less than two days old activeAt', () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(test_utils_1.TestUtils.generateFakePubKeyStr(), conversation_1.ConversationTypeEnum.GROUP);
            convo.set('active_at', Date.now() - 2 * 23 * 3600 * 1000);
            expect(swarmPolling.getPollingTimeout(types_1.PubKey.cast(convo.id))).to.eq(constants_1.SWARM_POLLING_TIMEOUT.ACTIVE);
        });
        it('returns INACTIVE for convo with undefined activeAt', () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(test_utils_1.TestUtils.generateFakePubKeyStr(), conversation_1.ConversationTypeEnum.GROUP);
            convo.set('active_at', undefined);
            expect(swarmPolling.getPollingTimeout(types_1.PubKey.cast(convo.id))).to.eq(constants_1.SWARM_POLLING_TIMEOUT.INACTIVE);
        });
        it('returns MEDIUM_ACTIVE for convo with activeAt of more than 2 days but less than a week old', () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(test_utils_1.TestUtils.generateFakePubKeyStr(), conversation_1.ConversationTypeEnum.GROUP);
            convo.set('active_at', Date.now() - 1000 * 3600 * 25 * 2);
            expect(swarmPolling.getPollingTimeout(types_1.PubKey.cast(convo.id))).to.eq(constants_1.SWARM_POLLING_TIMEOUT.MEDIUM_ACTIVE);
            convo.set('active_at', Date.now() - 1000 * 3600 * 24 * 7 + 3600);
            expect(swarmPolling.getPollingTimeout(types_1.PubKey.cast(convo.id))).to.eq(constants_1.SWARM_POLLING_TIMEOUT.MEDIUM_ACTIVE);
        });
        it('returns INACTIVE for convo with  activeAt of more than a week', () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(test_utils_1.TestUtils.generateFakePubKeyStr(), conversation_1.ConversationTypeEnum.GROUP);
            convo.set('active_at', Date.now() - 1000 * 3600 * 24 * 8);
            expect(swarmPolling.getPollingTimeout(types_1.PubKey.cast(convo.id))).to.eq(constants_1.SWARM_POLLING_TIMEOUT.INACTIVE);
        });
    });
    (0, mocha_1.describe)('pollForAllKeys', () => {
        beforeEach(() => {
            sinon_1.default.stub(DataItem, 'createOrUpdateItem').resolves();
        });
        afterEach(() => {
            sinon_1.default.restore();
        });
        it('does run for our pubkey even if activeAt is really old ', async () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(ourNumber, conversation_1.ConversationTypeEnum.PRIVATE);
            convo.set('active_at', Date.now() - 1000 * 3600 * 25);
            await swarmPolling.start(true);
            expect(pollOnceForKeySpy.callCount).to.eq(1);
            expect(pollOnceForKeySpy.firstCall.args).to.deep.eq([ourPubkey, false, 0]);
        });
        it('does run for our pubkey even if activeAt is recent ', async () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(ourNumber, conversation_1.ConversationTypeEnum.PRIVATE);
            convo.set('active_at', Date.now());
            await swarmPolling.start(true);
            expect(pollOnceForKeySpy.callCount).to.eq(1);
            expect(pollOnceForKeySpy.firstCall.args).to.deep.eq([ourPubkey, false, 0]);
        });
        it('does run for our pubkey even if activeAt is recent ', async () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(ourNumber, conversation_1.ConversationTypeEnum.PRIVATE);
            convo.set('active_at', Date.now());
            await swarmPolling.start(true);
            expect(pollOnceForKeySpy.callCount).to.eq(1);
            expect(pollOnceForKeySpy.firstCall.args).to.deep.eq([ourPubkey, false, 0]);
        });
        it('does run for group pubkey on start no matter the recent timestamp  ', async () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(test_utils_1.TestUtils.generateFakePubKeyStr(), conversation_1.ConversationTypeEnum.GROUP);
            convo.set('active_at', Date.now());
            const groupConvoPubkey = types_1.PubKey.cast(convo.id);
            swarmPolling.addGroupId(groupConvoPubkey);
            await swarmPolling.start(true);
            expect(pollOnceForKeySpy.callCount).to.eq(2);
            expect(pollOnceForKeySpy.firstCall.args).to.deep.eq([ourPubkey, false, 0]);
            expect(pollOnceForKeySpy.secondCall.args).to.deep.eq([groupConvoPubkey, true, 0]);
        });
        it('does run for group pubkey on start no matter the old timestamp if HF < 19', async () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(test_utils_1.TestUtils.generateFakePubKeyStr(), conversation_1.ConversationTypeEnum.GROUP);
            convo.set('active_at', 1);
            const groupConvoPubkey = types_1.PubKey.cast(convo.id);
            swarmPolling.addGroupId(groupConvoPubkey);
            await swarmPolling.start(true);
            expect(pollOnceForKeySpy.callCount).to.eq(2);
            expect(pollOnceForKeySpy.firstCall.args).to.deep.eq([ourPubkey, false, 0]);
            expect(pollOnceForKeySpy.secondCall.args).to.deep.eq([groupConvoPubkey, true, 0]);
        });
        it('does run for group pubkey on start no matter the old timestamp if HF >= 17.0 & < 18.0  ', async () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(test_utils_1.TestUtils.generateFakePubKeyStr(), conversation_1.ConversationTypeEnum.GROUP);
            getItemByIdStub.restore();
            getItemByIdStub = test_utils_1.TestUtils.stubDataItem('getItemById');
            getItemByIdStub
                .withArgs('hasSeenHardfork190')
                .resolves({ id: 'hasSeenHardfork190', value: true })
                .withArgs('hasSeenHardfork191')
                .resolves({ id: 'hasSeenHardfork191', value: false });
            convo.set('active_at', 1);
            const groupConvoPubkey = types_1.PubKey.cast(convo.id);
            swarmPolling.addGroupId(groupConvoPubkey);
            await swarmPolling.start(true);
            expect(pollOnceForKeySpy.callCount).to.eq(3);
            expect(pollOnceForKeySpy.firstCall.args).to.deep.eq([ourPubkey, false, 0]);
            expect(pollOnceForKeySpy.secondCall.args).to.deep.eq([groupConvoPubkey, true, undefined]);
            expect(pollOnceForKeySpy.thirdCall.args).to.deep.eq([groupConvoPubkey, true, -10]);
            getItemByIdStub.restore();
            getItemByIdStub = test_utils_1.TestUtils.stubDataItem('getItemById');
            getItemByIdStub.resolves();
        });
        it('does only poll from -10 for closed groups if HF >= 18.0  ', async () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(test_utils_1.TestUtils.generateFakePubKeyStr(), conversation_1.ConversationTypeEnum.GROUP);
            getItemByIdStub.restore();
            getItemByIdStub = test_utils_1.TestUtils.stubDataItem('getItemById');
            getItemByIdStub
                .withArgs('hasSeenHardfork190')
                .resolves({ id: 'hasSeenHardfork190', value: true })
                .withArgs('hasSeenHardfork191')
                .resolves({ id: 'hasSeenHardfork191', value: true });
            convo.set('active_at', 1);
            const groupConvoPubkey = types_1.PubKey.cast(convo.id);
            swarmPolling.addGroupId(groupConvoPubkey);
            await swarmPolling.start(true);
            expect(pollOnceForKeySpy.callCount).to.eq(2);
            expect(pollOnceForKeySpy.firstCall.args).to.deep.eq([ourPubkey, false, 0]);
            expect(pollOnceForKeySpy.secondCall.args).to.deep.eq([groupConvoPubkey, true, -10]);
            getItemByIdStub.restore();
            getItemByIdStub = test_utils_1.TestUtils.stubDataItem('getItemById');
            getItemByIdStub.resolves();
        });
        it('does run for group pubkey on start but not another time if activeAt is old ', async () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(test_utils_1.TestUtils.generateFakePubKeyStr(), conversation_1.ConversationTypeEnum.GROUP);
            convo.set('active_at', 1);
            const groupConvoPubkey = types_1.PubKey.cast(convo.id);
            swarmPolling.addGroupId(groupConvoPubkey);
            await swarmPolling.start(true);
            await swarmPolling.pollForAllKeys();
            expect(pollOnceForKeySpy.callCount).to.eq(3);
            expect(pollOnceForKeySpy.firstCall.args).to.deep.eq([ourPubkey, false, 0]);
            expect(pollOnceForKeySpy.secondCall.args).to.deep.eq([groupConvoPubkey, true, 0]);
            expect(pollOnceForKeySpy.thirdCall.args).to.deep.eq([ourPubkey, false, 0]);
        });
        it('does run twice if activeAt less than one hour ', async () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(test_utils_1.TestUtils.generateFakePubKeyStr(), conversation_1.ConversationTypeEnum.GROUP);
            convo.set('active_at', Date.now());
            const groupConvoPubkey = types_1.PubKey.cast(convo.id);
            swarmPolling.addGroupId(groupConvoPubkey);
            await swarmPolling.start(true);
            clock.tick(9000);
            clock.restore();
            await (0, Promise_1.sleepFor)(10);
            expect(pollOnceForKeySpy.callCount).to.eq(4);
            expect(pollOnceForKeySpy.firstCall.args).to.deep.eq([ourPubkey, false, 0]);
            expect(pollOnceForKeySpy.secondCall.args).to.deep.eq([groupConvoPubkey, true, 0]);
            expect(pollOnceForKeySpy.thirdCall.args).to.deep.eq([ourPubkey, false, 0]);
            expect(pollOnceForKeySpy.getCall(3).args).to.deep.eq([groupConvoPubkey, true, 0]);
        });
        it('does run twice if activeAt is inactive and we tick longer than 2 minutes', async () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(test_utils_1.TestUtils.generateFakePubKeyStr(), conversation_1.ConversationTypeEnum.GROUP);
            pollOnceForKeySpy.resetHistory();
            convo.set('active_at', Date.now());
            const groupConvoPubkey = types_1.PubKey.cast(convo.id);
            swarmPolling.addGroupId(groupConvoPubkey);
            await swarmPolling.start(true);
            const timeToTick = 3 * 60 * 1000;
            swarmPolling.forcePolledTimestamp(groupConvoPubkey, Date.now() - timeToTick);
            convo.set('active_at', Date.now() - 7 * 25 * 3600 * 1000);
            clock.tick(timeToTick);
            clock.restore();
            await (0, Promise_1.sleepFor)(10);
            expect(pollOnceForKeySpy.callCount).to.eq(4);
            expect(pollOnceForKeySpy.firstCall.args).to.deep.eq([ourPubkey, false, 0]);
            expect(pollOnceForKeySpy.secondCall.args).to.deep.eq([groupConvoPubkey, true, 0]);
            expect(pollOnceForKeySpy.thirdCall.args).to.deep.eq([ourPubkey, false, 0]);
            expect(pollOnceForKeySpy.getCalls()[3].args).to.deep.eq([groupConvoPubkey, true, 0]);
        });
        it('does run once only if group is inactive and we tick less than 2 minutes ', async () => {
            const convo = (0, conversations_1.getConversationController)().getOrCreate(test_utils_1.TestUtils.generateFakePubKeyStr(), conversation_1.ConversationTypeEnum.GROUP);
            pollOnceForKeySpy.resetHistory();
            convo.set('active_at', Date.now());
            const groupConvoPubkey = types_1.PubKey.cast(convo.id);
            swarmPolling.addGroupId(groupConvoPubkey);
            await swarmPolling.start(true);
            convo.set('active_at', Date.now() - 7 * 24 * 3600 * 1000 - 3600 * 1000);
            clock.tick(1 * 60 * 1000);
            expect(pollOnceForKeySpy.callCount).to.eq(3);
            expect(pollOnceForKeySpy.secondCall.args).to.deep.eq([groupConvoPubkey, true, 0]);
            expect(pollOnceForKeySpy.thirdCall.args).to.deep.eq([ourPubkey, false, 0]);
        });
        (0, mocha_1.describe)('multiple runs', () => {
            let convo;
            let groupConvoPubkey;
            beforeEach(async () => {
                convo = (0, conversations_1.getConversationController)().getOrCreate(test_utils_1.TestUtils.generateFakePubKeyStr(), conversation_1.ConversationTypeEnum.GROUP);
                convo.set('active_at', Date.now());
                groupConvoPubkey = types_1.PubKey.cast(convo.id);
                swarmPolling.addGroupId(groupConvoPubkey);
                await swarmPolling.start(true);
            });
            it('does run twice if activeAt is less than 2 days', async () => {
                pollOnceForKeySpy.resetHistory();
                convo.set('active_at', Date.now() - 2 * 24 * 3600 * 1000 - 3600 * 1000);
                const timeToTick = 6 * 1000;
                swarmPolling.forcePolledTimestamp(convo.id, timeToTick);
                clock.tick(timeToTick);
                await swarmPolling.pollForAllKeys();
                expect(pollOnceForKeySpy.callCount).to.eq(4);
                expect(pollOnceForKeySpy.firstCall.args).to.deep.eq([ourPubkey, false, 0]);
                expect(pollOnceForKeySpy.thirdCall.args).to.deep.eq([groupConvoPubkey, true, 0]);
                expect(pollOnceForKeySpy.secondCall.args).to.deep.eq([ourPubkey, false, 0]);
                expect(pollOnceForKeySpy.getCalls()[3].args).to.deep.eq([groupConvoPubkey, true, 0]);
            });
            it('does run twice if activeAt is more than 2 days old and we tick more than one minute ', async () => {
                pollOnceForKeySpy.resetHistory();
                convo.set('active_at', Date.now() - 2 * 25 * 3600 * 1000);
                const timeToTick = 65 * 1000;
                swarmPolling.forcePolledTimestamp(convo.id, timeToTick);
                clock.tick(timeToTick);
                await swarmPolling.pollForAllKeys();
                expect(pollOnceForKeySpy.callCount).to.eq(4);
                expect(pollOnceForKeySpy.firstCall.args).to.deep.eq([ourPubkey, false, 0]);
                expect(pollOnceForKeySpy.thirdCall.args).to.deep.eq([groupConvoPubkey, true, 0]);
                expect(pollOnceForKeySpy.secondCall.args).to.deep.eq([ourPubkey, false, 0]);
                expect(pollOnceForKeySpy.getCalls()[3].args).to.deep.eq([groupConvoPubkey, true, 0]);
            });
        });
    });
});
