"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importDefault(require("chai"));
const sinon_1 = __importStar(require("sinon")), sinon = sinon_1;
const utils_1 = require("../../../../bchat/utils");
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
const Promise_1 = require("../../../../bchat/utils/Promise");
const test_utils_1 = require("../../../test-utils");
chai_1.default.use(chai_as_promised_1.default);
chai_1.default.should();
const { expect } = chai_1.default;
describe('Promise Utils', () => {
    let pollSpy;
    let waitForTaskSpy;
    let waitUntilSpy;
    beforeEach(() => {
        pollSpy = sinon_1.default.spy(utils_1.PromiseUtils, 'poll');
        waitForTaskSpy = sinon_1.default.spy(utils_1.PromiseUtils, 'waitForTask');
        waitUntilSpy = sinon_1.default.spy(utils_1.PromiseUtils, 'waitUntil');
        test_utils_1.TestUtils.stubWindowLog();
    });
    afterEach(() => {
        sinon_1.default.restore();
    });
    describe('poll', () => {
        it('will call done on finished', async () => {
            const completionSpy = sinon_1.default.spy();
            const task = (done) => {
                completionSpy();
                done();
            };
            const promise = utils_1.PromiseUtils.poll(task, { interval: 10 });
            expect(pollSpy.callCount).to.equal(1);
            expect(completionSpy.callCount).to.equal(1);
            return promise;
        });
        it('can timeout a task', () => {
            const completionSpy = sinon_1.default.spy();
            const task = (_done) => undefined;
            const promise = utils_1.PromiseUtils.poll(task, { timeoutMs: 1, interval: 10 });
            expect(pollSpy.callCount).to.equal(1);
            expect(completionSpy.callCount).to.equal(0);
            return promise.should.eventually.be.rejectedWith('Periodic check timeout');
        });
        it('will recur according to interval option', async () => {
            const expectedRecurrences = 4;
            const timeout = 3000;
            const interval = 3;
            const recurrenceSpy = sinon_1.default.spy();
            const task = (done) => {
                recurrenceSpy();
                if (recurrenceSpy.callCount === expectedRecurrences) {
                    done();
                }
            };
            const promise = utils_1.PromiseUtils.poll(task, { timeoutMs: timeout, interval });
            await promise;
            expect(pollSpy.callCount).to.equal(1);
            expect(recurrenceSpy.callCount).to.equal(expectedRecurrences);
        });
    });
    describe('waitForTask', () => {
        it('can wait for a task', async () => {
            const completionSpy = sinon_1.default.spy();
            const task = (done) => {
                completionSpy();
                done();
            };
            const promise = utils_1.PromiseUtils.waitForTask(task);
            expect(waitForTaskSpy.callCount).to.equal(1);
            expect(completionSpy.callCount).to.equal(1);
            return promise;
        });
        it('can timeout a task', () => {
            const completionSpy = sinon_1.default.spy();
            const task = async (_done) => undefined;
            const promise = utils_1.PromiseUtils.waitForTask(task, 1);
            expect(waitForTaskSpy.callCount).to.equal(1);
            expect(completionSpy.callCount).to.equal(0);
            return promise.should.eventually.be.rejectedWith('Task timed out');
        });
    });
    describe('waitUntil', () => {
        it('can wait for check', async () => {
            const check = () => true;
            const promise = utils_1.PromiseUtils.waitUntil(check, 5);
            expect(waitUntilSpy.callCount).to.equal(1);
            return promise;
        });
        it('can timeout a check', () => {
            const check = () => false;
            const promise = utils_1.PromiseUtils.waitUntil(check, 1);
            expect(waitUntilSpy.callCount).to.equal(1);
            return promise.should.eventually.be.rejectedWith('Periodic check timeout');
        });
    });
    describe('allowOnlyOneAtATime', () => {
        it('start if not running', async () => {
            const spy = sinon.spy(async () => {
                return (0, Promise_1.sleepFor)(10);
            });
            await (0, Promise_1.allowOnlyOneAtATime)('testing', spy);
            expect(spy.callCount).to.be.eq(1);
        });
        it('starts only once if already running', async () => {
            const spy = sinon.spy(async () => {
                return (0, Promise_1.sleepFor)(10);
            });
            void (0, Promise_1.allowOnlyOneAtATime)('testing', spy);
            await (0, Promise_1.allowOnlyOneAtATime)('testing', spy);
            expect(spy.callCount).to.be.eq(1);
        });
        it('throw if took longer than expected timeout', async () => {
            const spy = sinon.spy(async () => {
                return (0, Promise_1.sleepFor)(10);
            });
            try {
                await (0, Promise_1.allowOnlyOneAtATime)('testing', spy, 5);
                throw new Error('should not get here');
            }
            catch (e) {
                console.warn(e);
                expect(e).to.be.be.eql(undefined, 'should be undefined');
            }
            expect(spy.callCount).to.be.eq(1);
        });
        it('does not throw if took less than expected timeout', async () => {
            const spy = sinon.spy(async () => {
                return (0, Promise_1.sleepFor)(10);
            });
            try {
                await (0, Promise_1.allowOnlyOneAtATime)('testing', spy, 15);
                throw new Error('should get here');
            }
            catch (e) {
                expect(e.message).to.be.be.eql('should get here');
            }
            expect(spy.callCount).to.be.eq(1);
        });
    });
    describe('hasAlreadyOneAtaTimeMatching', () => {
        it('returns true if already started', () => {
            const spy = sinon.spy(async () => {
                return (0, Promise_1.sleepFor)(10);
            });
            void (0, Promise_1.allowOnlyOneAtATime)('testing', spy);
            expect((0, Promise_1.hasAlreadyOneAtaTimeMatching)('testing')).to.be.eq(true, 'should be true');
        });
        it('returns false if not already started', () => {
            expect((0, Promise_1.hasAlreadyOneAtaTimeMatching)('testing2')).to.be.eq(false, 'should be false');
        });
    });
});
