"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockConversation = exports.generateFakeIncomingPrivateMessage = exports.generateClosedGroupMessage = exports.generateOpenGroupV2RoomInfos = exports.generateOpenGroupVisibleMessage = exports.generateOpenGroupMessageV2 = exports.generateVisibleMessage = void 0;
const uuid_1 = require("uuid");
const pubkey_1 = require("./pubkey");
const ClosedGroupVisibleMessage_1 = require("../../../bchat/messages/outgoing/visibleMessage/ClosedGroupVisibleMessage");
const conversation_1 = require("../../../models/conversation");
const VisibleMessage_1 = require("../../../bchat/messages/outgoing/visibleMessage/VisibleMessage");
const OpenGroupUtils_1 = require("../../../bchat/apis/open_group_api/utils/OpenGroupUtils");
const OpenGroupMessageV2_1 = require("../../../bchat/apis/open_group_api/opengroupV2/OpenGroupMessageV2");
const __1 = require("..");
const OpenGroupVisibleMessage_1 = require("../../../bchat/messages/outgoing/visibleMessage/OpenGroupVisibleMessage");
const message_1 = require("../../../models/message");
function generateVisibleMessage({ identifier, timestamp, } = {}) {
    return new VisibleMessage_1.VisibleMessage({
        body: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit',
        identifier: identifier ?? (0, uuid_1.v4)(),
        timestamp: timestamp || Date.now(),
        attachments: undefined,
        quote: undefined,
        expireTimer: undefined,
        lokiProfile: undefined,
        preview: undefined,
    });
}
exports.generateVisibleMessage = generateVisibleMessage;
function generateOpenGroupMessageV2() {
    return new OpenGroupMessageV2_1.OpenGroupMessageV2({
        sentTimestamp: Date.now(),
        sender: __1.TestUtils.generateFakePubKey().key,
        base64EncodedData: 'whatever',
    });
}
exports.generateOpenGroupMessageV2 = generateOpenGroupMessageV2;
function generateOpenGroupVisibleMessage() {
    return new OpenGroupVisibleMessage_1.OpenGroupVisibleMessage({
        timestamp: Date.now(),
    });
}
exports.generateOpenGroupVisibleMessage = generateOpenGroupVisibleMessage;
function generateOpenGroupV2RoomInfos() {
    return { roomId: 'main', serverUrl: 'http://116.203.70.33' };
}
exports.generateOpenGroupV2RoomInfos = generateOpenGroupV2RoomInfos;
function generateClosedGroupMessage(groupId) {
    return new ClosedGroupVisibleMessage_1.ClosedGroupVisibleMessage({
        identifier: (0, uuid_1.v4)(),
        groupId: groupId ?? (0, pubkey_1.generateFakePubKey)().key,
        chatMessage: generateVisibleMessage(),
    });
}
exports.generateClosedGroupMessage = generateClosedGroupMessage;
function generateFakeIncomingPrivateMessage() {
    const convoId = __1.TestUtils.generateFakePubKeyStr();
    return new message_1.MessageModel({
        conversationId: convoId,
        source: convoId,
        type: 'incoming',
    });
}
exports.generateFakeIncomingPrivateMessage = generateFakeIncomingPrivateMessage;
class MockConversation {
    id;
    type;
    attributes;
    constructor(params) {
        this.id = params.id ?? (0, pubkey_1.generateFakePubKey)().key;
        const members = params.isMediumGroup
            ? params.members ?? (0, pubkey_1.generateFakePubKeys)(10).map(m => m.key)
            : [];
        this.type = params.type;
        this.attributes = {
            id: this.id,
            name: '',
            profileName: undefined,
            type: params.type === conversation_1.ConversationTypeEnum.GROUP ? 'group' : params.type,
            members,
            left: false,
            expireTimer: 0,
            mentionedUs: false,
            unreadCount: 5,
            isKickedFromGroup: false,
            active_at: Date.now(),
            lastJoinedTimestamp: Date.now(),
            lastMessageStatus: undefined,
            lastMessage: null,
            zombies: [],
            triggerNotificationsFor: 'all',
            isTrustedForAttachmentDownload: false,
            isPinned: false,
            isApproved: false,
            didApproveMe: false,
        };
    }
    isPrivate() {
        return this.type === conversation_1.ConversationTypeEnum.PRIVATE;
    }
    isBlocked() {
        return false;
    }
    isPublic() {
        return this.id.match(OpenGroupUtils_1.openGroupPrefixRegex);
    }
    isMediumGroup() {
        return this.type === 'group';
    }
    get(obj) {
        return this.attributes[obj];
    }
}
exports.MockConversation = MockConversation;
