"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.stubWindowLog = exports.stubWindow = exports.stubCreateObjectUrl = exports.stubUtilWorker = exports.stubDataItem = exports.stubData = void 0;
const sinon_1 = __importDefault(require("sinon"));
const utilWorker = __importStar(require("../../../webworker/workers/util_worker_interface"));
const globalAny = global;
const Data = require('../../../../ts/data/data');
const DataItem = require('../../../../ts/data/channelsItem');
function stubData(fn) {
    return sinon_1.default.stub(Data, fn);
}
exports.stubData = stubData;
function stubDataItem(fn) {
    return sinon_1.default.stub(DataItem, fn);
}
exports.stubDataItem = stubDataItem;
function stubUtilWorker(fnName, returnedValue) {
    return sinon_1.default.stub(utilWorker, 'callUtilsWorker')
        .withArgs(fnName)
        .resolves(returnedValue);
}
exports.stubUtilWorker = stubUtilWorker;
function stubCreateObjectUrl() {
    global.URL = {};
    global.URL.createObjectURL = () => {
        return `${Date.now()}:${Math.floor(Math.random() * 1000)}`;
    };
}
exports.stubCreateObjectUrl = stubCreateObjectUrl;
function stubWindow(fn, value) {
    if (typeof globalAny.window === 'undefined') {
        globalAny.window = {};
    }
    const set = (newValue) => {
        globalAny.window[fn] = newValue;
    };
    const get = () => {
        return globalAny.window[fn];
    };
    globalAny.window[fn] = value;
    return {
        get,
        set,
    };
}
exports.stubWindow = stubWindow;
const enableLogRedirect = false;
const stubWindowLog = () => {
    stubWindow('log', {
        info: (args) => (enableLogRedirect ? console.info(args) : {}),
        warn: (args) => (enableLogRedirect ? console.warn(args) : {}),
        error: (args) => (enableLogRedirect ? console.error(args) : {}),
        debug: (args) => (enableLogRedirect ? console.debug(args) : {}),
    });
};
exports.stubWindowLog = stubWindowLog;
