"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const os_1 = __importDefault(require("os"));
const sinon_1 = __importDefault(require("sinon"));
const chai_1 = require("chai");
const Settings = __importStar(require("../../../ts/types/Settings"));
describe('Settings', () => {
    describe('isAudioNotificationSupported', () => {
        context('on macOS', () => {
            beforeEach(() => {
                sinon_1.default.stub(process, 'platform').value('darwin');
            });
            afterEach(() => {
                sinon_1.default.restore();
            });
            it('should return true', () => {
                chai_1.assert.isTrue(Settings.isAudioNotificationSupported());
            });
        });
        context('on Windows', () => {
            context('version 7', () => {
                beforeEach(() => {
                    sinon_1.default.stub(process, 'platform').value('win32');
                    sinon_1.default.stub(os_1.default, 'release').returns('7.0.0');
                });
                afterEach(() => {
                    sinon_1.default.restore();
                });
                it('should return false', () => {
                    chai_1.assert.isFalse(Settings.isAudioNotificationSupported());
                });
            });
            context('version 8+', () => {
                beforeEach(() => {
                    sinon_1.default.stub(process, 'platform').value('win32');
                    sinon_1.default.stub(os_1.default, 'release').returns('8.0.0');
                });
                afterEach(() => {
                    sinon_1.default.restore();
                });
                it('should return true', () => {
                    chai_1.assert.isTrue(Settings.isAudioNotificationSupported());
                });
            });
        });
        context('on Linux', () => {
            beforeEach(() => {
                sinon_1.default.stub(process, 'platform').value('linux');
            });
            afterEach(() => {
                sinon_1.default.restore();
            });
            it('should return false', () => {
                chai_1.assert.isFalse(Settings.isAudioNotificationSupported());
            });
        });
    });
    describe('isNotificationGroupingSupported', () => {
        context('on macOS', () => {
            beforeEach(() => {
                sinon_1.default.stub(process, 'platform').value('darwin');
            });
            afterEach(() => {
                sinon_1.default.restore();
            });
            it('should return true', () => {
                chai_1.assert.isTrue(Settings.isNotificationGroupingSupported());
            });
        });
        context('on Windows', () => {
            context('version 7', () => {
                beforeEach(() => {
                    sinon_1.default.stub(process, 'platform').value('win32');
                    sinon_1.default.stub(os_1.default, 'release').returns('7.0.0');
                });
                afterEach(() => {
                    sinon_1.default.restore();
                });
                it('should return false', () => {
                    chai_1.assert.isFalse(Settings.isNotificationGroupingSupported());
                });
            });
            context('version 8+', () => {
                beforeEach(() => {
                    sinon_1.default.stub(process, 'platform').value('win32');
                    sinon_1.default.stub(os_1.default, 'release').returns('8.0.0');
                });
                afterEach(() => {
                    sinon_1.default.restore();
                });
                it('should return true', () => {
                    chai_1.assert.isTrue(Settings.isNotificationGroupingSupported());
                });
            });
        });
        context('on Linux', () => {
            beforeEach(() => {
                sinon_1.default.stub(process, 'platform').value('linux');
            });
            afterEach(() => {
                sinon_1.default.restore();
            });
            it('should return true', () => {
                chai_1.assert.isTrue(Settings.isNotificationGroupingSupported());
            });
        });
    });
    describe('isHideMenuBarSupported', () => {
        context('on macOS', () => {
            beforeEach(() => {
                sinon_1.default.stub(process, 'platform').value('darwin');
            });
            afterEach(() => {
                sinon_1.default.restore();
            });
            it('should return false', () => {
                chai_1.assert.isFalse(Settings.isHideMenuBarSupported());
            });
        });
        context('on Windows', () => {
            context('version 7', () => {
                beforeEach(() => {
                    sinon_1.default.stub(process, 'platform').value('win32');
                    sinon_1.default.stub(os_1.default, 'release').returns('7.0.0');
                });
                afterEach(() => {
                    sinon_1.default.restore();
                });
                it('should return true', () => {
                    chai_1.assert.isTrue(Settings.isHideMenuBarSupported());
                });
            });
            context('version 8+', () => {
                beforeEach(() => {
                    sinon_1.default.stub(process, 'platform').value('win32');
                    sinon_1.default.stub(os_1.default, 'release').returns('8.0.0');
                });
                afterEach(() => {
                    sinon_1.default.restore();
                });
                it('should return true', () => {
                    chai_1.assert.isTrue(Settings.isHideMenuBarSupported());
                });
            });
        });
        context('on Linux', () => {
            beforeEach(() => {
                sinon_1.default.stub(process, 'platform').value('linux');
            });
            afterEach(() => {
                sinon_1.default.restore();
            });
            it('should return true', () => {
                chai_1.assert.isTrue(Settings.isHideMenuBarSupported());
            });
        });
    });
});
