"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAudio = exports.isVideo = exports.isImage = exports.isJPEG = exports.ODT = exports.VIDEO_QUICKTIME = exports.VIDEO_MP4 = exports.IMAGE_UNKNOWN = exports.IMAGE_TIFF = exports.IMAGE_PNG = exports.IMAGE_WEBP = exports.IMAGE_ICO = exports.IMAGE_BMP = exports.IMAGE_JPEG = exports.IMAGE_GIF = exports.AUDIO_OPUS = exports.AUDIO_MP3 = exports.AUDIO_WEBM = exports.AUDIO_AAC = exports.APPLICATION_JSON = exports.APPLICATION_OCTET_STREAM = void 0;
exports.APPLICATION_OCTET_STREAM = 'application/octet-stream';
exports.APPLICATION_JSON = 'application/json';
exports.AUDIO_AAC = 'audio/aac';
exports.AUDIO_WEBM = 'audio/webm';
exports.AUDIO_MP3 = 'audio/mp3';
exports.AUDIO_OPUS = 'audio/ogg';
exports.IMAGE_GIF = 'image/gif';
exports.IMAGE_JPEG = 'image/jpeg';
exports.IMAGE_BMP = 'image/bmp';
exports.IMAGE_ICO = 'image/x-icon';
exports.IMAGE_WEBP = 'image/webp';
exports.IMAGE_PNG = 'image/png';
exports.IMAGE_TIFF = 'image/tiff';
exports.IMAGE_UNKNOWN = 'image/unknown';
exports.VIDEO_MP4 = 'video/mp4';
exports.VIDEO_QUICKTIME = 'video/quicktime';
exports.ODT = 'application/vnd.oasis.opendocument.spreadsheet';
const isJPEG = (value) => value === 'image/jpeg';
exports.isJPEG = isJPEG;
const isImage = (value) => value?.length > 0 && value.startsWith('image/');
exports.isImage = isImage;
const isVideo = (value) => value?.length > 0 && value.startsWith('video/');
exports.isVideo = isVideo;
const isAudio = (value) => value?.length > 0 && value.startsWith('audio/') && !value.endsWith('aiff');
exports.isAudio = isAudio;
