"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPrintableError = exports.showCannotUpdateDialog = exports.showUpdateDialog = exports.showDownloadUpdateDialog = void 0;
const electron_1 = require("electron");
async function showDownloadUpdateDialog(mainWindow, messages) {
    const DOWNLOAD_BUTTON = 0;
    const LATER_BUTTON = 1;
    const options = {
        type: 'info',
        buttons: [messages.autoUpdateDownloadButtonLabel, messages.autoUpdateLaterButtonLabel],
        title: messages.autoUpdateNewVersionTitle,
        message: messages.autoUpdateNewVersionMessage,
        detail: messages.autoUpdateDownloadInstructions,
        defaultId: LATER_BUTTON,
        cancelId: DOWNLOAD_BUTTON,
    };
    const ret = await electron_1.dialog.showMessageBox(mainWindow, options);
    return ret.response === DOWNLOAD_BUTTON;
}
exports.showDownloadUpdateDialog = showDownloadUpdateDialog;
async function showUpdateDialog(mainWindow, messages) {
    const RESTART_BUTTON = 0;
    const LATER_BUTTON = 1;
    const options = {
        type: 'info',
        buttons: [messages.autoUpdateRestartButtonLabel, messages.autoUpdateLaterButtonLabel],
        title: messages.autoUpdateNewVersionTitle,
        message: messages.autoUpdateDownloadedMessage,
        detail: messages.autoUpdateNewVersionInstructions,
        defaultId: LATER_BUTTON,
        cancelId: RESTART_BUTTON,
    };
    const ret = await electron_1.dialog.showMessageBox(mainWindow, options);
    return ret.response === RESTART_BUTTON;
}
exports.showUpdateDialog = showUpdateDialog;
async function showCannotUpdateDialog(mainWindow, messages) {
    const options = {
        type: 'error',
        buttons: [messages.ok],
        title: messages.cannotUpdate,
        message: messages.cannotUpdateDetail,
    };
    await electron_1.dialog.showMessageBox(mainWindow, options);
}
exports.showCannotUpdateDialog = showCannotUpdateDialog;
function getPrintableError(error) {
    return error && error.stack ? error.stack : error;
}
exports.getPrintableError = getPrintableError;
