"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stop = exports.start = void 0;
const updater_1 = require("./updater");
let initialized = false;
let localUserConfig;
async function start(getMainWindow, userConfig, messages, logger) {
    if (initialized) {
        throw new Error('updater/start: Updates have already been initialized!');
    }
    if (!userConfig) {
        throw new Error('updater/start: userConfig is needed!');
    }
    if (!messages) {
        throw new Error('updater/start: Must provide messages!');
    }
    if (!logger) {
        throw new Error('updater/start: Must provide logger!');
    }
    initialized = true;
    localUserConfig = userConfig;
    if (autoUpdateDisabled()) {
        logger.info('updater/start: Updates disabled - not starting new version checks');
        return;
    }
    await (0, updater_1.start)(getMainWindow, messages, logger);
}
exports.start = start;
function stop() {
    if (initialized) {
        (0, updater_1.stop)();
        initialized = false;
    }
}
exports.stop = stop;
function autoUpdateDisabled() {
    const userSetting = localUserConfig.get('autoUpdate');
    const autoUpdate = typeof userSetting !== 'boolean' || userSetting;
    return (process.mas ||
        !autoUpdate);
}
