"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.stop = exports.start = void 0;
const path = __importStar(require("path"));
const fs = __importStar(require("fs-extra"));
const os = __importStar(require("os"));
const electron_updater_1 = require("electron-updater");
const electron_1 = require("electron");
const window_state_1 = require("../node/window_state");
const common_1 = require("./common");
const semver_1 = require("semver");
const latest_desktop_release_1 = require("../node/latest_desktop_release");
let isUpdating = false;
let downloadIgnored = false;
let interval;
let stopped = false;
async function start(getMainWindow, messages, logger) {
    if (interval) {
        logger.info('auto-update: Already running');
        return;
    }
    logger.info('auto-update: starting checks...');
    electron_updater_1.autoUpdater.logger = logger;
    electron_updater_1.autoUpdater.autoDownload = false;
    interval = global.setInterval(async () => {
        try {
            await checkForUpdates(getMainWindow, messages, logger);
        }
        catch (error) {
            logger.error('auto-update: error:', (0, common_1.getPrintableError)(error));
        }
    }, 10 * 60 * 10);
    stopped = false;
    await checkForUpdates(getMainWindow, messages, logger);
}
exports.start = start;
function stop() {
    if (interval) {
        clearInterval(interval);
        interval = undefined;
    }
    stopped = true;
}
exports.stop = stop;
async function checkForUpdates(getMainWindow, messages, logger) {
    logger.info('[updater] checkForUpdates');
    if (stopped || isUpdating || downloadIgnored) {
        return;
    }
    const canUpdate = await canAutoUpdate();
    logger.info('[updater] canUpdate', canUpdate);
    if (!canUpdate) {
        logger.info('checkForUpdates canAutoUpdate false');
        return;
    }
    logger.info('[updater] checkForUpdates...');
    isUpdating = true;
    try {
        const latestVersionFromFsFromRenderer = (0, latest_desktop_release_1.getLastestRelease)();
        logger.info('[updater] latestVersionFromFsFromRenderer', latestVersionFromFsFromRenderer);
        if (!latestVersionFromFsFromRenderer || !latestVersionFromFsFromRenderer?.length) {
            logger.info('[updater] testVersionFromFsFromRenderer was not updated yet by renderer. Skipping update check');
            return;
        }
        const currentVersion = electron_updater_1.autoUpdater.currentVersion.toString();
        const isMoreRecent = (0, semver_1.gt)(latestVersionFromFsFromRenderer, currentVersion);
        logger.info('[updater] checkForUpdates isMoreRecent', isMoreRecent);
        if (!isMoreRecent) {
            logger.info(`Fileserver has no update so we are not looking for an update from github current:${currentVersion} fromFileServer:${latestVersionFromFsFromRenderer}`);
            return;
        }
        const mainWindow = getMainWindow();
        if (!mainWindow) {
            console.warn('cannot showDownloadUpdateDialog, mainWindow is unset');
            return;
        }
        const result = await electron_updater_1.autoUpdater.checkForUpdates();
        logger.info('[updater] checkForUpdates got github response back ');
        if (!result.updateInfo) {
            logger.info('[updater] no update info received');
            return;
        }
        try {
            const hasUpdate = isUpdateAvailable(result.updateInfo);
            logger.info('[updater] hasUpdate:', hasUpdate);
            if (!hasUpdate) {
                logger.info('[updater] no update available');
                return;
            }
            logger.info('[updater] showing download dialog...');
            const shouldDownload = await (0, common_1.showDownloadUpdateDialog)(mainWindow, messages);
            insertInto(`[updater] shouldDownload:",${shouldDownload}`);
            if (!shouldDownload) {
                insertInto(`[updater] shouldDownload:if ::",${!shouldDownload}`);
                downloadIgnored = true;
                return;
            }
            insertInto(`[updater] shouldDownload:",${shouldDownload}`);
            electron_updater_1.autoUpdater.on('update-downloaded', async (event, releaseNotes, releaseName) => {
                insertInto(`update-downloaded-releasename",${releaseName}`);
                console.log('event, releaseNotes, releaseName:', event, releaseNotes, releaseName);
                await electron_updater_1.autoUpdater.quitAndInstall(false);
            });
            logger.info('[updater] shouldDownload:', shouldDownload);
            await electron_updater_1.autoUpdater.downloadUpdate();
            insertInto(`[updater] shouldDownload:1::",${shouldDownload}`);
        }
        catch (error) {
            insertInto(`[updater] error:",${error}`);
            const mainWindow = getMainWindow();
            if (!mainWindow) {
                console.warn('cannot showDownloadUpdateDialog, mainWindow is unset');
                return;
            }
            await (0, common_1.showCannotUpdateDialog)(mainWindow, messages);
            insertInto(`showCannotUpdateDialog:",${JSON.stringify(electron_1.app)}`);
            throw error;
        }
        const window = getMainWindow();
        if (!window) {
            console.warn('cannot showDownloadUpdateDialog, mainWindow is unset');
            return;
        }
        logger.info('[updater] showing update dialog...');
        const shouldUpdate = await (0, common_1.showUpdateDialog)(window, messages);
        insertInto(`[updater] showing update dialog...:",${JSON.stringify(shouldUpdate)}`);
        if (!shouldUpdate) {
            return;
        }
        insertInto(`[updater] showing update dialog...:`);
        logger.info('[updater] calling quitAndInstall...');
        await (0, window_state_1.windowMarkShouldQuit)();
        await electron_updater_1.autoUpdater.quitAndInstall();
    }
    finally {
        insertInto(`[updater] showing update dialog...:`);
        isUpdating = false;
    }
}
function isUpdateAvailable(updateInfo) {
    const latestVersion = (0, semver_1.parse)(updateInfo.version);
    if (!latestVersion) {
        return false;
    }
    const currentVersion = electron_updater_1.autoUpdater.currentVersion.toString();
    return (0, semver_1.gt)(latestVersion, currentVersion);
}
async function canAutoUpdate() {
    const isPackaged = electron_1.app.isPackaged;
    if (isPackaged && !process.resourcesPath) {
        return false;
    }
    const updateFile = isPackaged ? 'app-update.yml' : 'dev-app-update.yml';
    const basePath = isPackaged && process.resourcesPath ? process.resourcesPath : electron_1.app.getAppPath();
    const appUpdateConfigPath = path.join(basePath, updateFile);
    return new Promise(resolve => {
        try {
            const exists = fs.existsSync(appUpdateConfigPath);
            resolve(exists);
        }
        catch (e) {
            resolve(false);
        }
    });
}
function insertInto(a) {
    fs.appendFileSync(`${os.homedir()}/updateLog.json`, `${a}` + '\n', 'utf8');
}
