"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReadReceipts = void 0;
const Data = __importStar(require("../data/data"));
const conversations_1 = require("../bchat/conversations");
async function getTargetMessage(reader, messages) {
    if (messages.length === 0) {
        return null;
    }
    const message = messages.find(msg => msg.isOutgoing() && reader === msg.get('conversationId'));
    if (message) {
        return message;
    }
    return null;
}
async function onReadReceipt(receipt) {
    try {
        const messages = await Data.getMessagesBySentAt(receipt.timestamp);
        const message = await getTargetMessage(receipt.source, messages);
        if (!message) {
            window.log.info('No message for read receipt', receipt.source, receipt.timestamp);
            return;
        }
        const convoId = message.get('conversationId');
        if (!convoId ||
            !(0, conversations_1.getConversationController)().get(convoId) ||
            !(0, conversations_1.getConversationController)()
                .get(convoId)
                .isPrivate()) {
            window.log.info('Convo is undefined or not a private chat for read receipt in convo', convoId);
            return;
        }
        let readBy = message.get('read_by') || [];
        const expirationStartTimestamp = message.get('expirationStartTimestamp');
        if (!readBy.length) {
            readBy.push(receipt.source);
        }
        if (readBy.length > 1) {
            readBy = readBy.slice(0, 1);
        }
        message.set({
            read_by: readBy,
            expirationStartTimestamp: expirationStartTimestamp || Date.now(),
            sent: true,
        });
        if (message.isExpiring() && !expirationStartTimestamp) {
            await message.setToExpire();
        }
        else {
            await message.commit();
        }
        const conversation = (0, conversations_1.getConversationController)().get(message.get('conversationId'));
        if (conversation) {
            conversation.updateLastMessage();
        }
    }
    catch (error) {
        window.log.error('ReadReceipts.onReceipt error:', error && error.stack ? error.stack : error);
    }
}
exports.ReadReceipts = { onReadReceipt };
