"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SCEE = void 0;
const crypto = require("crypto");
const ALGORITHM_NAME = "aes-128-gcm";
const ALGORITHM_NONCE_SIZE = 12;
const ALGORITHM_TAG_SIZE = 16;
const ALGORITHM_KEY_SIZE = 16;
const PBKDF2_NAME = "sha256";
const PBKDF2_SALT_SIZE = 16;
const PBKDF2_ITERATIONS = 32767;
class SCEE {
    encryptString(plaintext, password) {
        let salt = crypto.randomBytes(PBKDF2_SALT_SIZE);
        let key = crypto.pbkdf2Sync(new Buffer(password, "utf8"), salt, PBKDF2_ITERATIONS, ALGORITHM_KEY_SIZE, PBKDF2_NAME);
        let ciphertextAndNonceAndSalt = Buffer.concat([salt, this.encrypt(new Buffer(plaintext, "utf8"), key)]);
        return ciphertextAndNonceAndSalt.toString("base64");
    }
    decryptString(base64CiphertextAndNonceAndSalt, password) {
        let ciphertextAndNonceAndSalt = new Buffer(base64CiphertextAndNonceAndSalt, "base64");
        let salt = ciphertextAndNonceAndSalt.slice(0, PBKDF2_SALT_SIZE);
        let ciphertextAndNonce = ciphertextAndNonceAndSalt.slice(PBKDF2_SALT_SIZE);
        let key = crypto.pbkdf2Sync(new Buffer(password, "utf8"), salt, PBKDF2_ITERATIONS, ALGORITHM_KEY_SIZE, PBKDF2_NAME);
        return this.decrypt(ciphertextAndNonce, key).toString("utf8");
    }
    encrypt(plaintext, key) {
        let nonce = crypto.randomBytes(ALGORITHM_NONCE_SIZE);
        let cipher = crypto.createCipheriv(ALGORITHM_NAME, key, nonce);
        let ciphertext = Buffer.concat([cipher.update(plaintext), cipher.final()]);
        return Buffer.concat([nonce, ciphertext, cipher.getAuthTag()]);
    }
    decrypt(ciphertextAndNonce, key) {
        let nonce = ciphertextAndNonce.slice(0, ALGORITHM_NONCE_SIZE);
        let ciphertext = ciphertextAndNonce.slice(ALGORITHM_NONCE_SIZE, ciphertextAndNonce.length - ALGORITHM_TAG_SIZE);
        let tag = ciphertextAndNonce.slice(ciphertext.length + ALGORITHM_NONCE_SIZE);
        let cipher = crypto.createDecipheriv(ALGORITHM_NAME, key, nonce);
        cipher.setAuthTag(tag);
        return Buffer.concat([cipher.update(ciphertext), cipher.final()]);
    }
}
exports.SCEE = SCEE;
